% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape.R
\name{reshape}
\alias{reshape}
\title{Reshape array}
\usage{
reshape(A, sz)
}
\arguments{
\item{A}{input matrix}

\item{sz}{vector containing the dimensions of the output vector}
}
\value{
the input matrix, reshaped according to the vector sz
}
\description{
Reshapes a matrix according to a certain number of dimensions
}
\details{
This function replicates the functionality of the \code{reshape()}
function on Matlab. This function is basically a fancy wrapper for the
\code{array()} function in R, but is useful because it saves the user translation
time. Moreover, it introduces validation code that alter the behavior of
\code{array()} and makes it more similar to \code{replicate()}.
}
\note{
The Matlab function also accepts as input the dismemberment of sz as
scalars.
}
\examples{
mx <- matrix(1:4, 2)
ra <- array(1:12, c(2, 3, 2))

mx
reshape(mx, c(1, 4))

ra
reshape(ra, c(3, 2, 2))
}
