% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialDataFunctions.R
\name{proximity}
\alias{proximity}
\title{Make potentials object--spatial proximity}
\usage{
proximity(scene, method, proximityFun = NULL, averageType = "mean",
  subject = "all", zeroPotDist = NULL)
}
\arguments{
\item{scene}{a matingScene object}

\item{method}{one of "maxProp", and "maxPropSqrd" see details for
further description}

\item{proximityFun}{a function used to calculate proximity. Not yet
implemented}

\item{averageType}{whether to calculate individual and population proximity
using the mean or median}

\item{subject}{whether you want pair, individual, population, or all.
Specifying more than one is allowed.}

\item{zeroPotDist}{the distance at which potential should be equal to zero}
}
\value{
A potentials object containing one more more of the following, depending the
input for \code{subject}: \cr
If \code{subject} is "population" the return list will contain a numeric
value that has a range depending on the \code{method}. If
\code{subject} is "pair" the return list will contain a matrix
with all pairwise proximity comparisons. If \code{subject} is "individual"
the return list will contain a dataframe with a column containing IDs and
a column containing proximity values. If \code{subject} is "all"
the return list will contain all three of the items above.
}
\description{
Calculate one of several measures of spatial proximity
}
\details{
If \code{method} is "maxProp" then proximity between two
individuals will be calculated as 1 - distance/max(distance).
If \code{method} is "maxPropSqrd" then proximity between two
individuals will be calculated as (1 - distance/max(distance))^2.
}
\examples{
pop <- simulateScene()
proximity(pop, "maxProp")
}
\author{
Danny Hanson
}

