/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.structure;

import choco.IPretty;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.structure.StoredBipartiteSet;
import choco.kernel.memory.structure.iterators.SBVSIterator1;
import choco.kernel.memory.structure.iterators.SBVSIterator2;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.Var;
import java.util.Arrays;
import java.util.List;

public final class StoredBipartiteVarSet<E extends Var>
extends StoredBipartiteSet<E>
implements IPretty {
    private E[] varsNotInstanciated = new Var[8];
    private int size = 0;
    private SBVSIterator1 _iterator1;
    private SBVSIterator2 _iterator2;

    public StoredBipartiteVarSet(IEnvironment env) {
        super(env);
    }

    @Override
    public void clear() {
        Arrays.fill(this.varsNotInstanciated, null);
        this.size = 0;
    }

    @Override
    public boolean add(E e) {
        this.ensureCapacity(this.size + 1);
        ((Var[])this.elementData)[this.size] = e;
        this.varsNotInstanciated[this.size++] = e;
        this.last.add(1);
        return true;
    }

    public void ensureCapacity(int expectedSize) {
        if (((Var[])this.elementData).length < expectedSize) {
            int newSize = ((Var[])this.elementData).length;
            while ((newSize *= 2) < expectedSize) {
            }
            Var[] oldElements = (Var[])this.elementData;
            this.elementData = new Var[newSize];
            System.arraycopy(oldElements, 0, this.elementData, 0, oldElements.length);
            oldElements = this.varsNotInstanciated;
            this.varsNotInstanciated = new Var[newSize];
            System.arraycopy(oldElements, 0, this.varsNotInstanciated, 0, oldElements.length);
        }
    }

    public E swap(int index) {
        this.RangeCheck(index);
        int idx = this.last.get() - 1;
        E tmp = this.varsNotInstanciated[index];
        this.varsNotInstanciated[index] = this.varsNotInstanciated[idx];
        this.varsNotInstanciated[idx] = tmp;
        this.last.set(idx);
        return tmp;
    }

    public List<E> toList() {
        Var[] t = new Var[this.size];
        System.arraycopy(this.elementData, 0, t, 0, this.size);
        return Arrays.asList(t);
    }

    @Override
    public E[] toArray() {
        Var[] t = new Var[this.size];
        System.arraycopy(this.elementData, 0, t, 0, this.size);
        return t;
    }

    @Override
    public boolean contains(E o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(E o) {
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (((Var[])this.elementData)[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(((Var[])this.elementData)[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String pretty() {
        return StringUtils.pretty((IPretty[])this.elementData, 0, this.size);
    }

    @Override
    public String toString() {
        return Arrays.toString(this.elementData);
    }

    @Override
    public E remove(int index) {
        throw new SolverException("Not yet implemented");
    }

    public final DisposableIterator<E> getNotInstanciatedVariableIterator() {
        if (this._iterator1 == null || !this._iterator1.reusable()) {
            this._iterator1 = new SBVSIterator1();
        }
        this._iterator1.init(this, (Var[])this.varsNotInstanciated, this.last);
        return this._iterator1;
    }

    public final DisposableIterator<E> getInstanciatedVariableIterator() {
        if (this._iterator2 == null || !this._iterator2.reusable()) {
            this._iterator2 = new SBVSIterator2();
        }
        this._iterator2.init((Var[])this.varsNotInstanciated, this.size);
        return this._iterator2;
    }
}

