% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.stabit2.R
\name{predict.stabit2}
\alias{predict.stabit2}
\title{Predict method for fitted matching models}
\usage{
\method{predict}{stabit2}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{a fitted object of class \code{stabit}}

\item{newdata}{optionally, a data frame in which to look for variables with which to 
predict. If omitted, the fitted linear predictors or the fitted response values are returned.}

\item{...}{.}
}
\value{
\code{predict.stabit2} returns a vector of predicted values for the latent outcome variable of an object of class \code{stabit}.
}
\description{
Calculate predicted values for matching models fitted with functions \code{stabit} and \code{stabit2}.
}
\examples{

## load the results from Klein (2015) paper
 data(klein15a)
 
## predict the latent outcome variable
 predict(klein15a)

}
\references{
Klein, T. (2015a). \href{https://ideas.repec.org/p/cam/camdae/1521.html}{Does Anti-Diversification Pay? A One-Sided Matching Model of Microcredit}.
\emph{Cambridge Working Papers in Economics}, #1521.
}
\author{
Thilo Klein
}
\keyword{summary}
