/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.set.AbstractLargeSetSConstraint;
import choco.kernel.solver.variables.set.SetVar;

public class InverseSet
extends AbstractLargeSetSConstraint {
    int varoffset;
    SetVar[] x;
    SetVar[] y;

    public InverseSet(SetVar[] x, SetVar[] y) {
        super(ArrayUtils.append(x, y));
        this.varoffset = x.length;
        this.x = x;
        this.y = y;
    }

    @Override
    public void awake() throws ContradictionException {
        int i;
        SetVar var;
        int idx;
        for (idx = 0; idx < this.x.length; ++idx) {
            var = this.x[idx];
            for (i = var.getEnveloppeInf(); i <= var.getEnveloppeSup(); ++i) {
                if (!var.isInDomainEnveloppe(i)) continue;
                if (i >= this.y.length) {
                    var.remFromEnveloppe(i, this, false);
                    continue;
                }
                if (this.y[i].isInDomainEnveloppe(idx)) continue;
                var.remFromEnveloppe(i, this, false);
            }
        }
        for (idx = 0; idx < this.y.length; ++idx) {
            var = this.y[idx];
            for (i = var.getEnveloppeInf(); i <= var.getEnveloppeSup(); ++i) {
                if (!var.isInDomainEnveloppe(i)) continue;
                if (i >= this.x.length) {
                    var.remFromEnveloppe(i, this, false);
                    continue;
                }
                if (this.x[i].isInDomainEnveloppe(idx)) continue;
                var.remFromEnveloppe(i, this, false);
            }
        }
        for (idx = 0; idx < this.x.length; ++idx) {
            var = this.x[idx];
            DisposableIntIterator it = var.getDomain().getKernelIterator();
            while (it.hasNext()) {
                this.awakeOnKer(idx, it.next());
            }
        }
        for (idx = 0; idx < this.y.length; ++idx) {
            var = this.y[idx];
            DisposableIntIterator it = var.getDomain().getKernelIterator();
            while (it.hasNext()) {
                this.awakeOnKer(idx + this.varoffset, it.next());
            }
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        boolean allinstance = true;
        for (SetVar var : (SetVar[])this.vars) {
            if (var.isInstantiated()) continue;
            allinstance = false;
            break;
        }
        if (allinstance && !this.isSatisfied()) {
            this.fail();
        }
    }

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        int var = varIdx < this.varoffset ? x + this.varoffset : x;
        int val = varIdx < this.varoffset ? varIdx : varIdx - this.varoffset;
        ((SetVar[])this.vars)[var].addToKernel(val, this, false);
    }

    @Override
    public void awakeOnEnv(int varIdx, int x) throws ContradictionException {
        int var = varIdx < this.varoffset ? x + this.varoffset : x;
        int val = varIdx < this.varoffset ? varIdx : varIdx - this.varoffset;
        ((SetVar[])this.vars)[var].remFromEnveloppe(val, this, false);
    }

    @Override
    public boolean isConsistent() {
        return this.isSatisfied();
    }

    @Override
    public boolean isSatisfied() {
        for (int i = 0; i < ((SetVar[])this.vars).length; ++i) {
            SetVar var = ((SetVar[])this.vars)[i];
            DisposableIntIterator itker = var.getDomain().getKernelIterator();
            while (itker.hasNext()) {
                int v;
                int val = itker.next();
                int ov = i < this.varoffset ? val + this.varoffset : val;
                if (((SetVar[])this.vars)[ov].isInDomainKernel(v = i < this.varoffset ? i : i - this.varoffset)) continue;
                return false;
            }
        }
        return true;
    }
}

