/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Arrays;
import java.util.Comparator;

public final class BoundAllDiff
extends AbstractLargeIntSConstraint {
    public static boolean PROPAGATE_ON_INSTANTIATIONS = true;
    public boolean PROPAGATE_ON_BOUNDS = true;
    int[] t;
    int[] d;
    int[] h;
    int[] bounds;
    int nbBounds;
    final Interval[] minsorted;
    final Interval[] maxsorted;
    boolean infBoundModified = true;
    boolean supBoundModified = true;

    public BoundAllDiff(IntDomainVar[] vars, boolean global) {
        super(ConstraintEvent.LINEAR, vars);
        int n = this.getNbVars();
        if (!global) {
            this.PROPAGATE_ON_BOUNDS = false;
        }
        this.t = new int[2 * n + 2];
        this.d = new int[2 * n + 2];
        this.h = new int[2 * n + 2];
        this.bounds = new int[2 * n + 2];
        Interval[] intervals = new Interval[n];
        this.minsorted = new Interval[n];
        this.maxsorted = new Interval[n];
        for (int i = 0; i < vars.length; ++i) {
            intervals[i] = new Interval();
            intervals[i].var = vars[i];
            intervals[i].idx = i;
            this.minsorted[i] = intervals[i];
            this.maxsorted[i] = intervals[i];
        }
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 11;
    }

    protected void sortIt() {
        Arrays.sort(this.minsorted, SORT.MIN);
        Arrays.sort(this.maxsorted, SORT.MAX);
        int min = this.minsorted[0].var.getInf();
        int max = this.maxsorted[0].var.getSup() + 1;
        int last = min - 2;
        int nb = 0;
        this.bounds[0] = last;
        int i = 0;
        int j = 0;
        while (true) {
            if (i < this.getNbVars() && min <= max) {
                if (min != last) {
                    this.bounds[++nb] = last = min;
                }
                this.minsorted[i].minrank = nb;
                if (++i >= this.getNbVars()) continue;
                min = this.minsorted[i].var.getInf();
                continue;
            }
            if (max != last) {
                this.bounds[++nb] = last = max;
            }
            this.maxsorted[j].maxrank = nb;
            if (++j == this.getNbVars()) break;
            max = this.maxsorted[j].var.getSup() + 1;
        }
        this.nbBounds = nb;
        this.bounds[nb + 1] = this.bounds[nb] + 2;
    }

    protected void pathset(int[] tab, int start, int end, int to) {
        int next;
        int prev = next = start;
        while (prev != end) {
            next = tab[prev];
            tab[prev] = to;
            prev = next;
        }
    }

    protected int pathmin(int[] tab, int i) {
        while (tab[i] < i) {
            i = tab[i];
        }
        return i;
    }

    protected int pathmax(int[] tab, int i) {
        while (tab[i] > i) {
            i = tab[i];
        }
        return i;
    }

    protected void filterLower() throws ContradictionException {
        int i;
        for (i = 1; i <= this.nbBounds + 1; ++i) {
            this.t[i] = this.h[i] = i - 1;
            this.d[i] = this.bounds[i] - this.bounds[i - 1];
        }
        for (i = 0; i < this.getNbVars(); ++i) {
            int x = this.maxsorted[i].minrank;
            int y = this.maxsorted[i].maxrank;
            int z = this.pathmax(this.t, x + 1);
            int j = this.t[z];
            int n = z;
            this.d[n] = this.d[n] - 1;
            if (this.d[n] == 0) {
                this.t[z] = z + 1;
                z = this.pathmax(this.t, this.t[z]);
                this.t[z] = j;
            }
            this.pathset(this.t, x + 1, z, z);
            if (this.d[z] < this.bounds[z] - this.bounds[y]) {
                this.fail();
            }
            if (this.h[x] > x) {
                int w = this.pathmax(this.h, this.h[x]);
                this.maxsorted[i].var.updateInf(this.bounds[w], this, false);
                this.pathset(this.h, x, w, w);
            }
            if (this.d[z] != this.bounds[z] - this.bounds[y]) continue;
            this.pathset(this.h, this.h[y], j - 1, y);
            this.h[y] = j - 1;
        }
    }

    protected void filterUpper() throws ContradictionException {
        int i;
        for (i = 0; i <= this.nbBounds; ++i) {
            this.t[i] = this.h[i] = i + 1;
            this.d[i] = this.bounds[i + 1] - this.bounds[i];
        }
        for (i = this.getNbVars() - 1; i >= 0; --i) {
            int x = this.minsorted[i].maxrank;
            int y = this.minsorted[i].minrank;
            int z = this.pathmin(this.t, x - 1);
            int j = this.t[z];
            int n = z;
            this.d[n] = this.d[n] - 1;
            if (this.d[n] == 0) {
                this.t[z] = z - 1;
                z = this.pathmin(this.t, this.t[z]);
                this.t[z] = j;
            }
            this.pathset(this.t, x - 1, z, z);
            if (this.d[z] < this.bounds[y] - this.bounds[z]) {
                this.fail();
            }
            if (this.h[x] < x) {
                int w = this.pathmin(this.h, this.h[x]);
                this.minsorted[i].var.updateSup(this.bounds[w] - 1, this, false);
                this.pathset(this.h, x, w, w);
            }
            if (this.d[z] != this.bounds[y] - this.bounds[z]) continue;
            this.pathset(this.h, this.h[y], j + 1, y);
            this.h[y] = j + 1;
        }
    }

    @Override
    public void awake() throws ContradictionException {
        for (int j = 0; j < ((IntDomainVar[])this.vars).length; ++j) {
            int right = Integer.MIN_VALUE;
            int left = Integer.MIN_VALUE;
            for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
                if (!((IntDomainVar[])this.vars)[i].isInstantiated()) continue;
                int val = ((IntDomainVar[])this.vars)[i].getVal();
                if (i == j) continue;
                if (val == right + 1) {
                    right = val;
                    continue;
                }
                ((IntDomainVar[])this.vars)[j].removeInterval(left, right, this, false);
                left = right = val;
            }
            ((IntDomainVar[])this.vars)[j].removeInterval(left, right, this, false);
        }
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.infBoundModified || this.supBoundModified) {
            this.sortIt();
            this.filterLower();
            this.filterUpper();
            this.infBoundModified = false;
            this.supBoundModified = false;
        }
    }

    @Override
    public void awakeOnInf(int i) throws ContradictionException {
        if (this.PROPAGATE_ON_BOUNDS) {
            this.infBoundModified = true;
            this.constAwake(false);
            for (int j = 0; j < ((IntDomainVar[])this.vars).length; ++j) {
                if (j == i || !((IntDomainVar[])this.vars)[j].isInstantiated() || ((IntDomainVar[])this.vars)[j].getVal() != ((IntDomainVar[])this.vars)[i].getInf()) continue;
                ((IntDomainVar[])this.vars)[i].updateInf(((IntDomainVar[])this.vars)[j].getVal() + 1, this, true);
            }
        }
    }

    @Override
    public void awakeOnSup(int i) throws ContradictionException {
        if (this.PROPAGATE_ON_BOUNDS) {
            this.supBoundModified = true;
            this.constAwake(false);
            for (int j = 0; j < ((IntDomainVar[])this.vars).length; ++j) {
                if (j == i || !((IntDomainVar[])this.vars)[j].isInstantiated() || ((IntDomainVar[])this.vars)[j].getVal() != ((IntDomainVar[])this.vars)[i].getSup()) continue;
                ((IntDomainVar[])this.vars)[i].updateSup(((IntDomainVar[])this.vars)[j].getVal() - 1, this, true);
            }
        }
    }

    @Override
    public void awakeOnInst(int i) throws ContradictionException {
        if (PROPAGATE_ON_INSTANTIATIONS) {
            this.infBoundModified = true;
            this.supBoundModified = true;
            this.constAwake(false);
            int val = ((IntDomainVar[])this.vars)[i].getVal();
            for (int j = 0; j < ((IntDomainVar[])this.vars).length; ++j) {
                if (j == i) continue;
                ((IntDomainVar[])this.vars)[j].removeVal(val, this, true);
            }
        }
    }

    @Override
    public void awakeOnBounds(int idx) throws ContradictionException {
        this.supBoundModified = true;
        this.infBoundModified = true;
        for (int j = 0; j < ((IntDomainVar[])this.vars).length; ++j) {
            if (j == idx || !((IntDomainVar[])this.vars)[j].isInstantiated()) continue;
            int val = ((IntDomainVar[])this.vars)[j].getVal();
            if (val == ((IntDomainVar[])this.vars)[idx].getInf()) {
                ((IntDomainVar[])this.vars)[idx].updateInf(val + 1, this, false);
            }
            if (val != ((IntDomainVar[])this.vars)[idx].getSup()) continue;
            ((IntDomainVar[])this.vars)[idx].updateSup(val - 1, this, false);
        }
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            for (int j = i + 1; j < ((IntDomainVar[])this.vars).length; ++j) {
                if (tuple[i] != tuple[j]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("BoundAllDiff({");
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntDomainVar var = ((IntDomainVar[])this.vars)[i];
            sb.append(var.pretty());
        }
        sb.append("})");
        return sb.toString();
    }

    @Override
    public int getFineDegree(int idx) {
        return ((IntDomainVar[])this.vars).length - 1;
    }

    private static class Interval {
        int minrank;
        int maxrank;
        IntDomainVar var;
        int idx;

        private Interval() {
        }
    }

    static enum SORT implements Comparator<Interval>
    {
        MAX{

            @Override
            public int compare(Interval o1, Interval o2) {
                return o1.var.getSup() - o2.var.getSup();
            }
        }
        ,
        MIN{

            @Override
            public int compare(Interval o1, Interval o2) {
                return o1.var.getInf() - o2.var.getInf();
            }
        };

    }
}

