/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing.trail;

import choco.kernel.memory.trailing.StoredLong;
import choco.kernel.memory.trailing.trail.ITrailStorage;

public class StoredLongTrail
implements ITrailStorage {
    private StoredLong[] variableStack;
    private long[] valueStack;
    private int[] stampStack;
    private int currentLevel = 0;
    private int[] worldStartLevels;
    private int maxUpdates = 0;

    public StoredLongTrail(int nUpdates, int nWorlds) {
        this.maxUpdates = nUpdates;
        this.variableStack = new StoredLong[this.maxUpdates];
        this.valueStack = new long[this.maxUpdates];
        this.stampStack = new int[this.maxUpdates];
        this.worldStartLevels = new int[nWorlds];
    }

    @Override
    public void clear() {
        this.currentLevel = 0;
    }

    @Override
    public void worldPush(int wi) {
        this.worldStartLevels[wi] = this.currentLevel;
    }

    @Override
    public void worldPop(int wi) {
        while (this.currentLevel > this.worldStartLevels[wi]) {
            --this.currentLevel;
            StoredLong v = this.variableStack[this.currentLevel];
            v._set(this.valueStack[this.currentLevel], this.stampStack[this.currentLevel]);
        }
    }

    @Override
    public int getSize() {
        return this.currentLevel;
    }

    @Override
    public void worldCommit(int wi) {
    }

    public void savePreviousState(StoredLong v, long oldValue, int oldStamp) {
        this.valueStack[this.currentLevel] = oldValue;
        this.variableStack[this.currentLevel] = v;
        this.stampStack[this.currentLevel] = oldStamp;
        ++this.currentLevel;
        if (this.currentLevel == this.maxUpdates) {
            this.resizeUpdateCapacity();
        }
    }

    private void resizeUpdateCapacity() {
        int newCapacity = this.maxUpdates * 3 / 2;
        StoredLong[] tmp1 = new StoredLong[newCapacity];
        System.arraycopy(this.variableStack, 0, tmp1, 0, this.variableStack.length);
        this.variableStack = tmp1;
        long[] tmp2 = new long[newCapacity];
        System.arraycopy(this.valueStack, 0, tmp2, 0, this.valueStack.length);
        this.valueStack = tmp2;
        int[] tmp3 = new int[newCapacity];
        System.arraycopy(this.stampStack, 0, tmp3, 0, this.stampStack.length);
        this.stampStack = tmp3;
        this.maxUpdates = newCapacity;
    }

    @Override
    public void resizeWorldCapacity(int newWorldCapacity) {
        int[] tmp = new int[newWorldCapacity];
        System.arraycopy(this.worldStartLevels, 0, tmp, 0, this.worldStartLevels.length);
        this.worldStartLevels = tmp;
    }
}

