% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttc.R
\name{ttc}
\alias{ttc}
\title{Top-Trading-Cycles Algorithm for the house allocation problem}
\usage{
ttc(P = NULL, X = NULL)
}
\arguments{
\item{P}{matrix of individuals' preference rankings (Rank Order Lists) over objects.}

\item{X}{2-column-matrix of objects (\code{obj}) and their owners (\code{ind}).}
}
\value{
\code{ttc} returns a 2-column matrix of the matching solution for the housing market problem based on the Top-Trading-Cycles algorithm.
}
\description{
Finds the stable matching in the 
\href{https://en.wikipedia.org/wiki/Top_trading_cycle}{house allocation problem} 
with existing tenants. Uses the Top-Trading-Cycles Algorithm proposed in Abdulkadiroglu and Sonmez (1999).
}
\examples{
## generate matrix of individuals' preference rankings over objects, a.k.a. Rank Order Lists (ROL)
P <- matrix(c(2, 5, 1, 4, 3,  # ROL of individual 1
              1, 5, 4, 3, 2,  # ind 2
              2, 1, 4, 3, 5,  # ind 3
              2, 4, 3,NA,NA,  # ind 4
              4, 3, 1, 2,NA), # ind 5
            byrow=FALSE, nrow=5); P 

## generate 2-column-matrix of objects ('obj') and their owners ('ind')
X <- data.frame(ind=1:5, obj=5:1); X

## find assignment based on TTC algorithm
ttc(P=P,X=X)
}
\references{
Abdulkadiroglu, A. and Sonmez, T. (1999). House Allocation with Existing Tenants. \emph{Journal of Economic Theory}, 88(2):233--260.

Shapley, L. and H. Scarf (1974). On Cores and Indivisibility. \emph{Journal of Mathematical Economics}, 1(1):23--37.
}
\author{
Thilo Klein
}
\keyword{algorithms}
