% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plp.R
\name{plp}
\alias{plp}
\title{Partitioning Linear Programme for the stable roommates problem}
\usage{
plp(V = NULL, N = NULL)
}
\arguments{
\item{V}{valuation matrix of dimension \code{NxN} that gives row-players valuation 
over column players (or vice versa).}

\item{N}{integer (divisible by 2) that gives the number of players in the market.}
}
\value{
\code{plp} returns a list with the following items.
\item{Valuation.matrix}{input values of V.}
\item{Assignment.matrix}{upper triangular matrix of dimension \code{NxN} with entries of 1 for equilibrium pairs and 0 otherwise.}
\item{Equilibrium.groups}{matrix that gives the \code{N/2} equilibrium pairs and equilibrium partners' mutual valuations.}
}
\description{
Finds the stable matching in the \href{http://en.wikipedia.org/wiki/Stable_roommates_problem}{stable roommates problem} 
with transferable utility. 
Uses the Partitioning Linear Programme formulated in Quint (1991).
}
\examples{
## Roommate problem with 10 players, transferable utility and random preferences:
plp(N=10)

## Roommate problem with 10 players, transferable utility and given preferences:
V <- matrix(rep(1:10, 10), 10, 10)
plp(V=V)
}
\author{
Thilo Klein
}
\references{
Quint, T. (1991). Necessary and sufficient conditions for balancedness 
in partitioning games. \emph{Mathematical Social Sciences}, 22(1):87--91.
}
\keyword{algorithms}

