% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_marquee.R
\name{geom_marquee}
\alias{geom_marquee}
\title{Draw text formatted with marquee}
\usage{
geom_marquee(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  size.unit = "mm",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used to override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{size.unit}{How the \code{size} aesthetic is interpreted: as millimetres
(\code{"mm"}, default), points (\code{"pt"}), centimetres (\code{"cm"}), inches (\code{"in"}),
or picas (\code{"pc"}).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather than
combining with them. This is most useful for helper functions that define
both data and aesthetics and shouldn't inherit behaviour from the default
plot specification}
}
\value{
A ggplot2 layer that can be added to a plot
}
\description{
The geom is an extension of \code{geom_text()} and \code{geom_label()} that allows you
to draw richly formatted text in marquee-markdown format in your plot. For
plain text it is a near-drop-in replacement for the above geoms except some
sizing might be very slightly different. However, using this geom you are
able to access the much more powerful font settings available in marquee, so
even then it might make sense to opt for this geom.
}
\details{
Styling of the text is based on a style set with the exception that the
standard aesthetics such as family, size, colour, fill, etc. are recognized
and applied to the base tag style. The default style set (\link{classic_style})
can be changed using the style aesthetic which can take a vector of style
sets so that each text can rely on it's own style if needed. As with
\code{\link[=element_marquee]{element_marquee()}}, the \code{fill} aesthetic is treated differently and not
applied to the base tag, but to the body tag as a \code{\link[=skip_inherit]{skip_inherit()}} style so
as to not propagate the fill.

Contrary to the standard text and label geoms, \code{geom_marquee()} takes a
\code{width} aesthetic that can be used to turn on soft wrapping of text. The
default value (\code{NA}) lets the text run as long as it want's (honoring hard
breaks), but setting this to something else will instruct marquee to use at
most that amount of space. You can use grid units to set it to an absolute
amount.
}
\examples{
\dontshow{if (rlang::is_installed("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(ggplot2)
# Standard use
p <- ggplot(mtcars, aes(wt, mpg))
p + geom_marquee(aes(label = rownames(mtcars)))

# Make use of more powerful font features (note, result may depend on fonts
# installed on the system)
p + geom_marquee(
  aes(label = rownames(mtcars)),
  style = classic_style(weight = "thin", width = "condensed")
)

# Turn on line wrapping
p + geom_marquee(aes(label = rownames(mtcars)), width = unit(2, "cm"))

# Style like label
label_style <- modify_style(
  classic_style(margin = trbl(0)),
  "body",
  padding = skip_inherit(trbl(4)),
  border = "black",
  border_size = skip_inherit(trbl(1)),
  border_radius = 3
)
p + geom_marquee(aes(label = rownames(mtcars), fill = gear), style = label_style)

# Use markdown to style the text
red_bold_names <- sub("(\\\\w+)", "{.red **\\\\1**}", rownames(mtcars))
p + geom_marquee(aes(label = red_bold_names))
\dontshow{\}) # examplesIf}
}
