% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allPotential.R
\name{allPotential}
\alias{allPotential}
\title{Calculates all Resource Potential indicators}
\usage{
allPotential(X, land, species.table, speciesinfo.table, resource.groups,
  minTL = 0, TE = 0.1, base.start, base.end, years, raw = TRUE,
  std = TRUE, glob.env = TRUE, export.path = NULL,
  export.id = NULL)
}
\arguments{
\item{X}{A dataframe of fishery independent data derived from research vessel
survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, \code{BIOMASS}, and \code{ABUNDANCE}. \code{YEAR} indicates
the year the observation was recorded, \code{ID} is an area code indicating
where the observation was recorded, \code{SPECIES} is a numeric code
indicating the species sampled, and \code{BIOMASS}/\code{ABUNDANCE} is the
corresponding biomass/abundance (stratified and corrected for catchability
as required).}

\item{land}{A dataframe of commercial landings data with columns \code{YEAR},
\code{ID}, \code{SPECIES} and \code{CATCH}. \code{YEAR} indicates the year
the landing was recorded, \code{ID} is an area code indicating where the
landing was recorded, \code{SPECIES} is a numeric code indicating the
species landed, and \code{CATCH} is the corresponding landed weight.}

\item{species.table}{A table where the column names match the entries in
\code{resource.groups}. Column entries are the species codes indicating the
species from \code{X} included in each group. \code{species.table} may also
include columns for other species groups; these will be ignored.}

\item{speciesinfo.table}{A table with columns \code{SPECIES} and the
corresponding \code{TL_LAND} (trophic level of landed species). Entries in
the \code{SPECIES} column should be the unique values of species codes in
\code{land} (or a subset thereof). Other columns will be ignored.}

\item{resource.groups}{A vector indicating the species groups for which to
calculate the resource potential. Each entry must be a character string
matching the name of a column in \code{species.table}. If
\code{resource.groups = NULL}, these indicators will not be calculated.}

\item{minTL}{The minimum trophic level of species to include to calculate FiB.
If \code{minTL = NULL}, FiB will not be calculated. Default is \code{minTL =
0}.}

\item{TE}{Trophic efficiency, used to calculate FiB. Default is \code{TE =
0.1}, i.e., a trophic efficiency of 10\%. If \code{TE = NULL}, FiB will not
be calculated.}

\item{base.start}{Year indicating the beginning of the baseline period for
calculating FiB. The average landings and average mean trophic level of the
landings over the baseline period are used as baseline values to calculate
FiB. \code{land} must include data for the baseline period. If
\code{base.start = NULL}, FiB will not be calculated.}

\item{base.end}{Year indicating the end of the baseline period for calculating
FiB. The average landings and average mean trophic level of the landings
over the baseline period are used as baseline values to calculate FiB.
\code{land} must include data for the baseline period. If \code{base.end =
NULL}, FiB will not be calculated.}

\item{years}{A vector of years for which to calculate indicators.}

\item{raw}{A logical value. If \code{raw = TRUE}, the raw indicator values are
returned by the function. If \code{raw = FALSE}, the raw indicator values are
not returned. Default is \code{raw = TRUE}. Either \code{raw} or \code{std}
must be \code{TRUE}.}

\item{std}{A logical value. If \code{std = TRUE}, the standardized indicator
values for each area \code{ID} are returned by the function. Indicators are
standardized using z-scores, i.e., by subtracting the mean and dividing by
the standard deviation (ignoring \code{NA} values). If \code{std = FALSE},
the standardized indicator values are not returned. Default is \code{std =
TRUE}. Either \code{raw} or \code{std} must be \code{TRUE}.}

\item{glob.env}{Logical value indicating whether to return output to global
environment. Default is \code{glob.env = TRUE}.}

\item{export.path}{File path indicating where to save a .csv file of
calculated indicators (named potential_export.id.csv; see below). If
\code{export.file = NULL}, the indicator dataframe will not be exported as a
.csv file. Default is \code{export.path = NULL}.}

\item{export.id}{Character string to modify the name of the .csv file (if
export.path is specified), for example an area name or date of analysis. The
exported .csv file is named potential_export.id.csv. Default is
\code{export.id = NULL}.}
}
\value{
Returns a dataframe with columns \code{ID}, \code{YEAR}, and
 indicators corresponding to the arguments supplied to the function.
 Standardized indicators are noted with \code{_s} in the name.
}
\description{
This function calculates all (or a subset) of the Resource
 Potential indicators for \eqn{j} areas and \eqn{i} years. The user can
 choose whether the function returns the indicator dataframe to the global
 environment, exports the dataframe to a .csv file, or both. The user can
 also choose whether the function returns the raw indicator values, the
 standardized (z-score) values, or both.
}
\details{
This function calculates the Resource Potential indicators: Abundance
 and Biomass of the community, Resource Potential of predefined species
 groups, and Fishing-in-Balance (FiB). If data are not available to calculate
 one or more of these indicators, a subset will be returned. See the help
 file for the individual functions for information on how each indicator is
 calculated.
}
\examples{
# Compile data
data(X)
data(land)
data(species.table)
data(species.info)

# Species groups of interest
resource.groups <- c("ALL", "CLUPEIDS", "FINFISH", "FLATFISH",
   "FORAGE",  "GADOIDS", "GROUNDFISH")

# Calculate standardized indicators
allPotential(X = X, land = land, species.table = species.table,
   speciesinfo.table = species.info, resource.groups = resource.groups,
   TE = 0.1, base.start = 2014, base.end = 2015, years = c(2014:2019),
   raw = FALSE, std = TRUE)

}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.
}
\seealso{
Other resource potential indicators: \code{\link{fishingInBalance}},
  \code{\link{resourcePotential}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{resource potential indicators}
