## ---- warnings = FALSE, eval = FALSE, results = FALSE-------------------------
#  library(bench)
#  library(ggplot2)
#  library(margins)
#  library(marginaleffects)
#  
#  margins_pkg <- function(mod, dat, unit_ses) {
#      margins(mod, unit_ses = unit_ses)
#  }
#  
#  marginaleffects_pkg <- function(mod, dat, unit_ses) {
#      marginaleffects(mod, vcov = unit_ses)
#  }
#  
#  simulate <- function(N) {
#      dat <- data.frame(
#              x2 = rnorm(N),
#              x1 = rnorm(N),
#              x3 = rnorm(N),
#              x4 = rnorm(N))
#      pr <- plogis(dat$x1 + dat$x2 + dat$x3 + dat$x4 + dat$x3 * dat$x4)
#      dat$y <- rbinom(N, 1, pr)
#      return(dat)
#  }
#  
#  fit <- function(dat) {
#      glm(y ~ x1 + x2 + x3 * x4, data = dat, family = binomial)
#  }
#  
#  results <- bench::press(
#      N = c(25, 50, 100, 200, 400, 800, 1500, 5000, 10000),
#      unit_ses = c(FALSE, TRUE),
#      {
#      dat <- simulate(N)
#      mod <- fit(dat)
#      bench::mark(
#          check = FALSE,
#          max_iterations = 3,
#          margins_pkg(mod, dat, unit_ses),
#          marginaleffects_pkg(mod, dat, unit_ses))
#      }
#  )

## ---- eval = FALSE------------------------------------------------------------
#  results$pkg = as.character(results$expression)
#  ggplot(results, aes(N, median, linetype = pkg)) +
#      geom_line() +
#      facet_wrap(~unit_ses, scales = "free_y") +
#      theme_minimal() +
#      theme(legend.position = "bottom")

