% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addHomeButton.R
\name{addHomeButton}
\alias{addHomeButton}
\alias{removeHomeButton}
\title{Add a home button / zoom-to-layer button to a map.}
\usage{
addHomeButton(map, ext, layer.name = "layer", position = "bottomright")

removeHomeButton(map)
}
\arguments{
\item{map}{a mapview or leaflet object.}

\item{ext}{the \code{\link{extent}} / \code{\link{bbox}} to zoom to.}

\item{layer.name}{the name of the layer to be zoomed to (or any character
string)}

\item{position}{the position of the button (one of 'topleft', 'topright',
'bottomleft', 'bottomright'). Defaults to 'bottomright'.}
}
\description{
This function adds a button to the map that enables zooming to a
provided \code{\link{extent}} / \code{\link{bbox}}.

Use removeHomeButton to remove home button
}
\section{Functions}{
\itemize{
\item \code{removeHomeButton}: remove a homeButton from a map
}}
\examples{
\dontrun{
library(mapview)
library(raster)

m <- leaflet() \%>\% addTiles() \%>\% addCircleMarkers(data = breweries91) \%>\%
  addHomeButton(extent(breweries91), "breweries91")
m

## remove the button
m1 <- removeHomeButton(m)
m1

addHomeButton(m1, extent(breweries91), "anynamewilldoactually", 'topleft')
}


}

