% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_ggmap.R
\name{map_ggmap}
\alias{map_ggmap}
\title{ggpmap visualization of species occurences}
\usage{
map_ggmap(x, zoom = 3, point_color = "#86161f", lon = "longitude",
  lat = "latitude", ...)
}
\arguments{
\item{x}{The data. An object of class \code{occdat}, \code{occdatind},
\code{gbif}, \code{SpatialPoints}, \code{SpatialPointsDataFrame}, or
\code{data.frame}. The package \pkg{spocc} needed for
the first two, and \pkg{rgbif} needed for the third. When \code{data.frame}
input, any number of columns allowed, but with at least the following:
name (the taxonomic name), latitude (in dec. deg.), longitude (in dec. deg.)}

\item{zoom}{zoom level for map. Adjust depending on how your data look.}

\item{point_color}{Default color of your points}

\item{lon, lat}{(character) Longitude and latitude variable names. Ignored
unless \code{data.frame} input to \code{x} parameter. We attempt to guess, but
if nothing close, we stop. Default: \code{longitude} and \code{latitude}}

\item{...}{Ignored}
}
\description{
ggpmap visualization of species occurences
}
\examples{
\dontrun{
## spocc
library("spocc")
gd <- occ(query = 'Accipiter striatus', from = 'gbif', limit=75, has_coords = TRUE)
map_ggmap(gd)
map_ggmap(gd$gbif)

## rgbif
library("rgbif")
res <- occ_search(scientificName = "Puma concolor", limit = 100)
map_ggmap(res)

## data.frame
df <- data.frame(name = c('Poa annua', 'Puma concolor', 'Foo bar'),
                 longitude = c(-120, -121, -123),
                 latitude = c(41, 42, 45), stringsAsFactors = FALSE)
map_ggmap(df)

### usage of occ2sp()
#### SpatialPoints
spdat <- occ2sp(gd)
map_ggmap(spdat)
#### SpatialPointsDataFrame
spdatdf <- as(spdat, "SpatialPointsDataFrame")
map_ggmap(spdatdf)
}
}

