% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglike_hmm.R
\name{loglike_hmm}
\alias{loglike_hmm}
\title{Multipoint log-likelihood computation}
\usage{
loglike_hmm(input.map, input.data = NULL, verbose = FALSE)
}
\arguments{
\item{input.map}{An object of class \code{mappoly.map}}

\item{input.data}{An object of class \code{mappoly.data}, which was used to generate \code{input.map}}

\item{verbose}{If \code{TRUE}, map information is shown; if
\code{FALSE}(default), no output is produced}
}
\description{
Update the multipoint log-likelihood of a given map 
using the method proposed by \cite{Mollinari and Garcia (2019)}.
}
\examples{
 \donttest{
  hexa.map<-loglike_hmm(maps.hexafake[[1]])
  hexa.map
 }
 
}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \url{https://doi.org/10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
