# igraph ------------------------------------------------------------------


#' make igraph
#'
#' @param mapperobject mapper object generated by mappeR
#'
#' @return an igraph object
#' @export
#' @examples
#' data = data.frame(x = sapply(1:100, function(x) cos(x)), y = sapply(1:100, function(x) sin(x)))
#'
#' projy = data$y
#'
#' cover = create_width_balanced_cover(min(projy), max(projy), 10, 25)
#'
#' mapperobj = create_1D_mapper_object(data, dist(data), data$y, cover, "single")
#'
#' mapper_object_to_igraph(mapperobj)
mapper_object_to_igraph <- function(mapperobject) {
  vertices = mapperobject[[1]]
  edges = mapperobject[[2]]

  if (length(edges$source) <= 1) {
    if (edges$source == "") {
      mappergraph = graph_from_data_frame(d = data.frame(id = rownames(vertices), id = rownames(vertices)),
                                          vertices = vertices)
      mappergraph = delete_edges(mappergraph, E(mappergraph))
    }
  } else {
    mappergraph = graph_from_data_frame(d = edges,
                                        directed = FALSE,
                                        vertices = vertices)
  }

  mappergraph = set_vertex_attr(mappergraph, "label", value = NA)
  mappergraph = set_vertex_attr(mappergraph, "size", value = sqrt(vertices$cluster_size))
  if ("bin" %in% colnames(vertices)) {
    num_bins = max(vertices$bin)
    colfunc = colorRampPalette(c("blue", "gold", "red"))
    mappergraph = set_vertex_attr(mappergraph,
                                  "color",
                                  value = sapply(vertices$bin, function(x)
                                    colfunc(num_bins)[x]))
  }

  return(mappergraph)
}
