% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navigation.R
\name{mb_matrix}
\alias{mb_matrix}
\title{Retrieve a matrix of travel times from the Mapbox Directions API}
\usage{
mb_matrix(
  origins,
  destinations = NULL,
  profile = "driving",
  fallback_speed = NULL,
  output = c("duration", "distance"),
  duration_output = c("minutes", "seconds"),
  access_token = NULL
)
}
\arguments{
\item{origins}{The input coordinates of your request. Acceptable inputs include a list of
coordinate pair vectors in \code{c(x, y)} format or an \code{sf} object.
For sf linestrings or polygons, the distance between centroids will be taken.}

\item{destinations}{The destination coordinates of your request. If \code{NULL} (the default), a many-to-many matrix using \code{origins} will be returned.}

\item{profile}{One of "driving" (the default), "driving-traffic", "walking", or "cycling".}

\item{fallback_speed}{A value expressed in kilometers per hour used to estimate travel time when a route cannot be found between locations. The returned travel time will be based on the straight-line estimate of travel between the locations at the specified fallback speed.}

\item{output}{one of \code{"duration"} (the default), which will be measured in either minutes or seconds (depending on the value of \code{duration_output}), or \code{"distance"}, which will be returned in meters.}

\item{duration_output}{one of \code{"minutes"} (the default) or \code{"seconds"}}

\item{access_token}{A Mapbox access token (required)}
}
\value{
An R matrix of source-destination travel times.
}
\description{
Retrieve a matrix of travel times from the Mapbox Directions API
}
\examples{
\dontrun{

library(mapboxapi)
library(tigris)
library(mapdeck)

philly_tracts <- tracts("PA", "Philadelphia", cb = TRUE, class = "sf")
downtown_philly <- mb_geocode("Philadelphia City Hall, Philadelphia PA")

time_to_downtown <- mb_matrix(philly_tracts, downtown_philly)

philly_tracts$time <- time_to_downtown

mapdeck(style = mapdeck_style("light")) \%>\%
  add_polygon(
    data = philly_tracts,
    fill_colour = "time",
    fill_opacity = 0.6,
    legend = TRUE
  )
}

}
