% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_from.R
\name{from}
\alias{from}
\alias{from_subgraphs}
\alias{from_egos}
\alias{from_waves}
\alias{from_slices}
\title{Tools for joining lists of networks, graphs, and matrices}
\usage{
from_subgraphs(.data)

from_egos(.data)

from_waves(.data)

from_slices(.data, remove.duplicates = FALSE)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{remove.duplicates}{Should duplicates be removed?
By default FALSE.
If TRUE, duplicated edges are removed.}
}
\value{
A tidygraph object combining the list of network data.
}
\description{
These functions offer tools for joining lists of manynet-consistent objects
(matrices, igraph, tidygraph, or network objects).
Joining expects a list of objects and returns a single network object.
}
\section{Functions}{
\itemize{
\item \code{from_subgraphs()}: Returns a single network object
from a list of subgraphs.

\item \code{from_egos()}: Returns a single network object
from a list of egos.

\item \code{from_waves()}: Returns a single network object
from a list of waves.

\item \code{from_slices()}: Returns a single network object
from a list of slices.

}}
\examples{
ison_adolescents \%>\%
  mutate(unicorn = sample(c("yes", "no"), 8, replace = TRUE)) \%>\%
  to_subgraphs(attribute = "unicorn") \%>\%
  from_subgraphs()
ison_adolescents \%>\%
  activate(edges) \%>\%
  to_egos() \%>\%
  from_egos()
ison_adolescents \%>\%
  mutate_ties(wave = sample(1:4, 10, replace = TRUE)) \%>\%
  to_waves(attribute = "wave") \%>\%
  from_waves()
ison_adolescents \%>\%
  mutate_ties(time = 1:10, increment = 1) \%>\% 
  add_ties(c(1,2), list(time = 3, increment = -1)) \%>\% 
  to_slices(slice = c(5,7)) \%>\%
  from_slices()
}
\seealso{
Other manipulations: 
\code{\link{add}},
\code{\link{miss}},
\code{\link{reformat}},
\code{\link{split}()},
\code{\link{tidy}},
\code{\link{transform}()}
}
\concept{manipulations}
