# WARNING - Generated by {fusen} from dev/import-data.Rmd: do not edit by hand

#' Evaluate the spectra regularities
#'
#' Assess whether all the spectra in the list are not empty, of the same length and correspond to profile data.
#'
#' @param spectra_list A list of [MALDIquant::MassSpectrum] objects
#'
#' @return A list of logical vectors of length `spectra_list` indicating if the spectra are empty (`is_empty`), of an odd length (`is_outlier_length`) or not a profile spectra (`is_not_regular`).
#'
#' @seealso [process_spectra]
#'
#' @export
#' @examples
#' # Get an example directory of six Bruker MALDI Biotyper spectra
#' directory_biotyper_spectra <- system.file(
#'   "toy-species-spectra",
#'   package = "maldipickr"
#' )
#' # Import the six spectra
#' spectra_list <- import_biotyper_spectra(directory_biotyper_spectra)
#' # Display the list of checks, with FALSE where no anomaly is detected
#' check_spectra(spectra_list)
#' # The overall sanity can be checked with Reduce
#' Reduce(any, check_spectra(spectra_list)) # Should be FALSE
check_spectra <- function(spectra_list) {
  # Checking spectra are not empty
  empty_spectra <- sapply(spectra_list, MALDIquant::isEmpty)
  # Checking spectra are the same length
  ## Getting the most common length
  common_length <- sapply(spectra_list, length) %>%
    # gives length as character/names and occurrence as value
    table() %>%
    which.max() %>%
    # extract length
    names() %>%
    strtoi()
  length_spectra <- sapply(spectra_list, length) == common_length
  # Checking spectra are profile data
  regular_spectra <- sapply(spectra_list, MALDIquant::isRegular)
  # Summarise the checks
  checking_list <- list(
    is_empty = empty_spectra,
    is_outlier_length = !length_spectra,
    is_not_regular = !regular_spectra
  )
  if (any(Reduce(any, checking_list))) {
    # List all the spectra that should be removed
    to_remove <- lapply(checking_list, which) %>%
      unlist() %>%
      unique() %>%
      paste(collapse = ",")
    warning(
      "Some spectra (", to_remove, ") are incorrect (empty, outlier length or irregular).\n",
      "They can be removed as follow:\n",
      " spectra_list <- spectra_list[-c(", to_remove, ")]"
    )
  }
  return(checking_list)
}
