% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r.jive.predict.edit.R
\name{SVDmiss2}
\alias{SVDmiss2}
\title{Modified SVDmiss function (package  SpatioTemporal)}
\usage{
SVDmiss2(X, niter = 200, ncomp = dim(X)[2], conv.reldiff = 0.001)
}
\arguments{
\item{X}{\code{X}  Data matrix, with missing values marked by 'NA'.}

\item{niter}{\code{niter}  Maximum number of iterations to run before exiting, 'Inf' will run until the 'conv.reldiff' criteria is met.}

\item{ncomp}{\code{ncomp}  Number of SVD components to use in the reconstruction (>0).}

\item{conv.reldiff}{\code{conv.reldiff}  Assume the iterative procedure has converged when the relative difference between two consecutive iterations is less than 'conv.reldiff'.}
}
\value{
See SpatioTemporal:: SVDmiss for details
}
\description{
Modify ncomp = min(ncol(X),nrow(X),ncomp) for the matrix with nrow(X)<ncol(X)
}
\details{
See SVDmiss(package:SpatioTemporal) for details.
}
