% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_save.R
\name{lsave}
\alias{lsave}
\alias{lload}
\title{Read and write lvec object to file}
\usage{
lsave(x, filename, overwrite = TRUE, compress = FALSE)

lload(filename)
}
\arguments{
\item{x}{\code{\link{lvec}} object to save}

\item{filename}{name of the file(s) to save the lvec to. See details.}

\item{overwrite}{overwrite existing files or abort when files would be 
overwritten.}

\item{compress}{a logical specifying if the data should be compressed. 
(see \code{\link{saveRDS}}).}
}
\value{
\code{lsave} does not return anything. \code{lload} returns an 
\code{\link{lvec}}.
}
\description{
Read and write lvec object to file
}
\details{
The \code{\link{lvec}} is written in chunks to a number of RDS files using
\code{\link{saveRDS}}. When filename contains the extension 'RDS' 
(capitalisation may differ), this extension is stripped from the filename. 
After that the lvec is written in blocks (or chunks) to files having 
names \code{<filename>.00001.RDS}, \code{<filename>.00002.RDS} etc. Some 
additional data (data type, the number of blocks, the size of the lvec, etc)
is written to the file \code{<filename>.RDS}.
}
