% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/luajr-package.R
\docType{package}
\name{luajr-package}
\alias{luajr}
\alias{luajr-package}
\title{luajr: LuaJIT Scripting}
\description{
'luajr' provides an interface to \href{https://luajit.org}{LuaJIT}, a
just-in-time compiler for the \href{https://www.lua.org}{Lua scripting language}.
It allows users to run Lua code from R.
}
\section{The R API}{

\itemize{
\item \code{\link[=lua]{lua()}}: run Lua code
\item \code{\link[=lua_func]{lua_func()}}: make a Lua function callable from R
\item \code{\link[=lua_shell]{lua_shell()}}: run an interactive Lua shell
\item \code{\link[=lua_open]{lua_open()}}: create a new Lua state
\item \code{\link[=lua_reset]{lua_reset()}}: reset the default Lua state
\item \code{\link[=lua_parallel]{lua_parallel()}}: run Lua code in parallel
}
}

\section{Further reading}{

For an introduction to 'luajr', see \code{vignette("luajr")}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/nicholasdavies/luajr}
  \item \url{https://nicholasdavies.github.io/luajr/}
  \item Report bugs at \url{https://github.com/nicholasdavies/luajr/issues}
}

}
\author{
\strong{Maintainer}: Nicholas Davies \email{nicholas.davies@lshtm.ac.uk} (\href{https://orcid.org/0000-0002-1740-1412}{ORCID}) (Author of the R package wrapper) [contributor, copyright holder]

Authors:
\itemize{
  \item Mike Pall (Author of the embedded LuaJIT compiler) [copyright holder]
}

Other contributors:
\itemize{
  \item Lua.org, PUC-Rio (Copyright holders over portions of Lua source code included in LuaJIT) [copyright holder]
}

}
