% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsplincom.R
\name{lsplincom}
\alias{lsplincom}
\alias{print.lsplincom}
\alias{summary.lsplincom}
\title{Linear Combination of Estimators for \pkg{lspartition} Package}
\usage{
lsplincom(y, x, G, R, eval = NULL, neval = NULL, level = 95,
  band = FALSE, cb.method = NULL, cb.grid = NULL, cb.ngrid = 50,
  B = 1000, subset = NULL, knot = NULL, ...)

\method{print}{lsplincom}(x, ...)

\method{summary}{lsplincom}(object, ...)
}
\arguments{
\item{y}{Outcome variable.}

\item{x}{Independent variable. A matrix or data frame.}

\item{G}{Group indicator. It may take on multiple discrete values.}

\item{R}{A numeric vector giving the linear combination of interest. Each element is the coefficient
of the conditional mean estimator of one group, and they are ordered ascendingly along the value
of \code{G}.}

\item{eval}{Evaluation points. A matrix or data frame.}

\item{neval}{Number of quantile-spaced evaluating points.}

\item{level}{Confidence level used for confidence intervals; default is \code{level=95}.}

\item{band}{If \code{TRUE}, the critical value for constructing confidence band is calculated. Default
is \code{band=FALSE}.}

\item{cb.method}{Method used to calculate the critical value for confidence bands.
Options are \code{"pl"} for a simulation-based plug-in procedure, and
\code{"wb"} for a wild bootstrap procedure. If \code{band=TRUE} with
\code{cb.method} unspecified, default is \code{cb.method="pl"}.}

\item{cb.grid}{A matrix containing all grid points used to construct confidence bands. Each row
correponds to the coordinates of one grid point.}

\item{cb.ngrid}{A numeric vector of the same length as \code{ncol(x)}. Each element corresponds to
the number of grid points for each dimension used to implement uniform inference.
Default is \code{uni.ngrid=50}.}

\item{B}{Number of simulated samples used to obtain the critical value for confidence bands.
Default is \code{B=1000}.}

\item{subset}{Optional rule specifying a subset of observations to be used.}

\item{knot}{A list of numeric vectors giving the knot positions (including boundary knots) for each dimension
which are used in the main regression. The length of the list is equal to \code{ncol(x)}.
If not specified, it uses the number of knots either specified by users
or computed by the companion command \code{lspkselect} to generate the
corresponding knots according to the rule specified by \code{ktype}. See help for \code{\link{lsprobust}}.}

\item{...}{Arguments to be passed to the function. See \code{lsprobust}.}

\item{object}{class \code{lsplincom} objects.}
}
\value{
\item{\code{Estimate}}{ A matrix containing eval (grid points), N (effective sample sizes),
                            tau.cl (point estimates with a basis of order \code{m}), tau.bc (bias corrected point
                            estimates with a basis of order \code{m.bc}), se.cl (standard error corresponding
                            to tau.cl), and se.rb (robust standard error).}
       \item{\code{sup.cval}}{ Critical value for constructing confidence bands.}
       \item{\code{opt}}{ A list containing options passed to the function.}
}
\description{
\code{lsplincom} implements user-specified linear combinations across different data sub-groups for regression functions estimation, and computes corresponding (pointwise and uniform) robust bias-corrected inference measures. Estimation and inference is implemented using the \pkg{lspartition} package.
            See \href{https://sites.google.com/site/nppackages/lspartition/Cattaneo-Farrell_2013_JoE.pdf?attredirects=0}{Cattaneo and Farrell (2013)} and \href{https://arxiv.org/abs/1804.04916}{Cattaneo, Farrell and Feng (2019a)} for complete details.

            A detailed introduction to this command is given in \href{https://arxiv.org/abs/1906.00202}{Cattaneo, Farrell and Feng (2019b)}.

            For more details, and related Stata and R packages useful for empirical analysis,
            visit \url{https://sites.google.com/site/nppackages/}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print}: \code{print} method for class "\code{lsplincom}".

\item \code{summary}: \code{summary} method for class "\code{lsplincom}"
}}

\examples{
x   <- runif(500)
y   <- sin(4*x)+rnorm(500)
z   <- c(rep(0, 250), rep(1, 250))
est <- lsplincom(y, x, z, c(-1, 1))
summary(est)

}
\references{
Cattaneo, M. D., M. H. Farrell, and Y. Feng (2019a): \href{https://arxiv.org/abs/1804.04916}{Large Sample Properties of Partitioning-Based Series Estimators}. Annals of Statistics, forthcoming. arXiv:1804.04916.

Cattaneo, M. D., M. H. Farrell, and Y. Feng (2019b): \href{https://arxiv.org/abs/1906.00202}{lspartition: Partitioning-Based Least Squares Regression}. Working paper.
}
\seealso{
\code{\link{lsprobust}}, \code{\link{lspkselect}}, \code{\link{lsprobust.plot}},
}
\author{
Matias D. Cattaneo, Princeton University, Princeton, NJ. \email{cattaneo@princeton.edu}.

Max H. Farrell, University of Chicago, Chicago, IL. \email{max.farrell@chicagobooth.edu}.

Yingjie Feng (maintainer), Princeton University, Princeton, NJ. \email{yjfeng@umich.edu}.
}
