% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/genproc.R
\name{genproc}
\alias{genproc}
\title{Generalized Procrustes Rotation}
\usage{
genproc(configs, maxit = 50L, reltol = 1e-06, random = FALSE)
}
\arguments{
\item{configs}{A list of original configuration matrices}

\item{maxit}{The maximum number of iterations allowed}

\item{reltol}{The relative error tolerance for determining numeric convergence.}

\item{random}{Logical indicating whether or not to use random starts (only applicable when the
dimensionality is two).}
}
\description{
This function finds K orthogonal rotation matrices so that the rotated versions of the input
configurations match each other optimally in the least-squares sense. The algorithm depends on the
starting values for the rotation matrices. At present identity matrices are used as starting values.
Only rotations / reflections are considered -- no scaling or translation factors are included.
}
\references{
Gower, J. C., & Dijksterhuis, G. B. (2004). Procrustes problems (Vol. 3). Oxford: Oxford University Press.
}

