% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignProportions.R
\name{getDesignTwoOrdinal}
\alias{getDesignTwoOrdinal}
\title{Power and Sample Size for the Wilcoxon Test for Two-Sample
Ordinal Response}
\usage{
getDesignTwoOrdinal(
  beta = NA_real_,
  n = NA_real_,
  ncats = NA_integer_,
  pi1 = NA_real_,
  pi2 = NA_real_,
  allocationRatioPlanned = 1,
  rounding = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{ncats}{The number of categories of the ordinal response.}

\item{pi1}{The prevalence of each category for the treatment group.
Only need to specify the valued for the first \code{ncats-1} categories.}

\item{pi2}{The prevalence of each category for the control group.
Only need to specify the valued for the first \code{ncats-1} categories.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{rounding}{Whether to round up sample size. Defaults to 1 for
sample size rounding.}

\item{alpha}{The significance level. Defaults to 0.025.}
}
\value{
An S3 class \code{designTwoOrdinal} object with the following
components:
\itemize{
\item \code{power}: The power to reject the null hypothesis.
\item \code{alpha}: The two-sided significance level.
\item \code{n}: The maximum number of subjects.
\item \code{ncats}: The number of categories of the ordinal response.
\item \code{pi1}: The prevalence of each category for the treatment group.
\item \code{pi2}: The prevalence of each category for the control group.
\item \code{meanscore1}: The mean midrank score for the treatment group.
\item \code{meanscore2}: The mean midrank score for the control group.
\item \code{allocationRatioPlanned}: Allocation ratio for the active treatment
versus control.
\item \code{rounding}: Whether to round up sample size.
}
}
\description{
Obtains the power given sample size or obtains the sample
size given power for the Wilcoxon test for two-sample ordinal response.
}
\examples{

(design1 <- getDesignTwoOrdinal(
  beta = 0.1, ncats = 4, pi1 = c(0.55, 0.3, 0.1),
  pi2 = c(0.214, 0.344, 0.251), alpha = 0.025))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
