% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_header.R
\name{write_header}
\alias{write_header}
\title{Write LPJmL header object to an LPJmL input (or output) file}
\usage{
write_header(filename, header, overwrite = FALSE)
}
\arguments{
\item{filename}{Filename to write header into.}

\item{header}{The header to be written.}

\item{overwrite}{Whether to overwrite an existing output file
(default \code{FALSE}).}
}
\value{
Returns \code{filename} invisibly.
}
\description{
Write an LPJmL clm header to a file. The header has to be a list
following the structure returned by \code{\link[=read_header]{read_header()}} or \code{\link[=create_header]{create_header()}}.
The function will fail if the output file exists already unless \code{overwrite}
is set to \code{TRUE}.
}
\examples{
\dontrun{
header <- read_header(filename = "old_filename.clm")
write_header(
  filename = "new_filename.clm",
  header = header,
  overwrite = FALSE
)
}

}
\seealso{
\itemize{
\item \code{\link[=create_header]{create_header()}} for creating headers from scratch and for a more
detailed description of the LPJmL header format.
\item \code{\link[=read_header]{read_header()}} for reading headers from files.
}
}
