% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_header.R
\name{read_header}
\alias{read_header}
\title{Read header (any version) from LPJmL input/output file}
\usage{
read_header(filename, force_version = NULL, verbose = TRUE)
}
\arguments{
\item{filename}{Filename to read header from.}

\item{force_version}{Manually set clm version. The default value \code{NULL} means
that the version is determined automatically from the header. Set only if
the version number in the file header is incorrect.}

\item{verbose}{If \code{TRUE} (the default), \code{read_header} provides some feedback
when using default values for missing parameters. If \code{FALSE}, only errors
are reported.}
}
\value{
The function returns a list with 3 components:
\itemize{
\item name: Header name, e.g. "LPJGRID"; describes the type of data in the file.
\item header: Vector of header values ('version', 'order', 'firstyear',
'nyear', 'firstcell', 'ncell', 'nbands', 'cellsize_lon', 'scalar',
'cellsize_lat', 'datatype', 'nstep', 'timestep') describing the file
structure. If header version is <4, the header is partially filled with
default values.
\item endian: Endianness of file (\code{"little"} or \code{"big"}).
}
}
\description{
Reads a header from an LPJmL clm file. CLM is the default
format used for LPJmL input files and can also be used for output files.
}
\examples{
\dontrun{
header <- read_header("filename.clm")
}

}
\seealso{
\itemize{
\item \code{\link[=create_header]{create_header()}} for a more detailed description of the LPJmL header
format.
\item \code{\link[=write_header]{write_header()}} for writing headers to files.
}
}
