% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loopFuns.R
\name{raster_qevd}
\alias{raster_qevd}
\title{Return a raster of EVD Quantiles}
\usage{
raster_qevd(x, p, evd_mod_str, interval = NULL, lower.tail = TRUE)
}
\arguments{
\item{x}{SpatRasterDataset of EVD parameters, e.g. loc, scale, shape}

\item{p}{probability value.}

\item{evd_mod_str}{either a string "fgumbel", "fgev" or "fgumbelx" from the extreme value distribution (evd) in the evd package}

\item{interval}{A length two vector containing the end-points of the interval to be searched for the quantiles, passed to the uniroot function.}

\item{lower.tail}{Logical; if TRUE (default), probabilities are P \eqn{x \le y}), otherwise P (X > x).}
}
\value{
gives the quantile function corresponding to p
}
\description{
Return a raster of EVD Quantiles
}
\examples{
require(terra)
r = rast(system.file("extdata/50km_AnnMax_agcd_v1_tmax_mean_r005_daily_1980-2019.nc",
                     package = "loopevd"))
r2 = aggregate(r,4) #lower the resolution for a fast example
gumbel_r = raster_fevd(r2,"fgumbel")
AEP_10pc = raster_qevd(gumbel_r,1-0.1,"fgumbel") # 10\% Annual Exceedance Probability.
}
\seealso{
\code{\link[evd:gev]{evd::qgev()}}, \code{\link[evd:gumbelx]{evd::qgumbelx()}}
}
