% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loopFuns.R
\name{df_cievd}
\alias{df_cievd}
\title{Return a numeric vector of confidence intervals for EVD quantiles}
\usage{
df_cievd(x, p, ci = 0.95, cores = 8)
}
\arguments{
\item{x}{A data.frame of EVD parameters and associated covariance matrix. Must include 'loc', 'scale', 'shape', and 'cov*' column names.}

\item{p}{A single probability value for the quantile (e.g. 0.99).}

\item{ci}{Confidence level for the interval (default is 0.95).}

\item{cores}{Number of parallel cores to use. If >1, parallel processing is used via \code{parallel::parLapply()}.}
}
\value{
A numeric vector giving the confidence interval widths for each row in \code{x}.
}
\description{
Return a numeric vector of confidence intervals for EVD quantiles
}
\details{
This function calculates confidence intervals for extreme value quantiles using the delta method. The required input is a row-wise data frame with EVD parameters and their variance-covariance elements.
Internally uses \code{ismev::gev.rl.gradient()} and \code{ismev::q.form()}.
}
\examples{
\dontrun{
  df <- data.frame(loc = 1, scale = 0.5, shape = 0.1,
                   cov_1 = 0.01, cov_2 = 0.001, cov_3 = 0.002,
                   cov_4 = 0.001, cov_5 = 0.01, cov_6 = 0.001,
                   cov_7 = 0.002, cov_8 = 0.001, cov_9 = 0.02)
  df_cievd(df, p = 0.99, ci = 0.95, cores = 2)
}

}
\seealso{
\code{\link[ismev:ismev-internal]{ismev::gev.rl.gradient()}}, \code{\link[ismev:ismev-internal]{ismev::q.form()}}
}
