% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netcdf_parse.R
\name{add_nc_atts}
\alias{add_nc_atts}
\title{Add Global Attribute Metadata to Netcdf File}
\usage{
add_nc_atts(
  outfile,
  r,
  creator_name = "",
  creator_email = "",
  references = "",
  title = "",
  summary = "",
  keywords = "",
  history = "",
  licence = "",
  Disclaimer = ""
)
}
\arguments{
\item{outfile}{character the file to be edited}

\item{r}{SpatRaster the dataset in raster format e.g. r = terra::rast(outfile)}

\item{creator_name}{character, optional. The name of the person (or other creator type specified by the creator_type attribute) principally responsible for creating this data.}

\item{creator_email}{character, optional. The email address of the person (or other creator type specified by the creator_type attribute) principally responsible for creating this data.}

\item{references}{character, optional. Published or web-based references that describe the data or methods used to produce it. Recommend URIs (such as a URL or DOI) for papers or other references. This attribute is defined in the CF conventions.}

\item{title}{character, optional. A short phrase or sentence describing the dataset. In many discovery systems, the title will be displayed in the results list from a search, and therefore should be human readable and reasonable to display in a list of such names. This attribute is also recommended by the NetCDF Users Guide and the CF conventions.}

\item{summary}{character, optional. A paragraph describing the dataset, analogous to an abstract for a paper.}

\item{keywords}{character, optional. A comma-separated list of key words and/or phrases. Keywords may be common words or phrases, terms from a controlled vocabulary (GCMD is often used), or URIs for terms from a controlled vocabulary (see also "keywords_vocabulary" attribute).}

\item{history}{character, optional. Provides an audit trail for modifications to the original data. This attribute is also in the NetCDF Users Guide: 'This is a character array with a line for each invocation of a program that has modified the dataset. Well-behaved generic netCDF applications should append a line containing: date, time of day, user name, program name and command arguments.' To include a more complete description you can append a reference to an ISO Lineage entity; see NOAA EDM ISO Lineage guidance.}

\item{licence}{character, optional.}

\item{Disclaimer}{character, optional.}
}
\value{
see https://wiki.esipfed.org/Attribute_Convention_for_Data_Discovery_1-3, http://cfconventions.org/cf-conventions/cf-conventions.html
}
\description{
Improve FAIR metadata record with consideration of CF conventions https://cfconventions.org/Data/cf-conventions/cf-conventions-1.10/cf-conventions.html
}
\examples{
## Not run:
tf = tempfile("test.nc")
tf
file.copy(system.file("extdata/50km_AnnMax_agcd_v1_tmax_mean_r005_daily_1980-2019.nc",
package = "loopevd"),tf)
r = terra::rast(tf)
add_nc_atts(tf,r,creator_name="add_nc_atts examples")
}
