% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axecute.R
\name{axecute}
\alias{axecute}
\title{Creation of a log and axecution of a file}
\usage{
axecute(
  file,
  log_name = NA,
  log_path = NA,
  include_rds = FALSE,
  quit_on_error = TRUE,
  to_report = c("messages", "output", "result"),
  show_repo_url = FALSE,
  ...
)
}
\arguments{
\item{file}{String. Path to file to execute}

\item{log_name}{String. Name of log file}

\item{log_path}{String. Path to log file}

\item{include_rds}{Boolean. Option to export log object as Rds file.
Defaults to FALSE}

\item{quit_on_error}{Boolean. Should the session quit with status 1 on error?
Defaults to TRUE}

\item{to_report}{String vector. Objects to optionally report, may include as
many as necessary:
\itemize{
\item messages: any messages generated by program execution
\item output: any output generated by program execution
\item result: any result generated by program execution
}}

\item{show_repo_url}{Boolean. Should the repository URLs be reported
Defaults to FALSE}

\item{...}{Not used}
}
\value{
0 if there are no errors or 1 if there are any errors
}
\description{
\code{axecute()} creates a log, executes a file, and returns 0 if there are no
errors or 1 if there are any errors
}
\examples{
dir <- tempdir()
text <- 'print("Hello, logrxperson!")'
fileConn <- file(file.path(dir, "hello.R"))
writeLines(text, fileConn)
close(fileConn)

axecute(file.path(dir, "hello.R"))


fileConn <- file(file.path(dir, "hello.Rmd"))
writeLines(text, fileConn)
close(fileConn)

axecute(file.path(dir, "hello.Rmd"))
}
