% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logic.boosting.R
\name{fitLinearLogicModel}
\alias{fitLinearLogicModel}
\title{Linear models based on logic terms}
\usage{
fitLinearLogicModel(X, y, Z = NULL, disj, Z.interactions = TRUE)
}
\arguments{
\item{X}{Matrix or data frame of binary input data.
This object should correspond to the binary matrix for fitting the model.}

\item{y}{Response vector. 0-1 coding for binary outcomes.}

\item{Z}{Optional quantitative covariables supplied as a matrix or
data frame. Only used (and required) if the model was fitted using them.}

\item{disj}{Integer matrix of logic terms. As in \code{\link{logicDT}},
each row corresponds to a term/conjunction. Negative values indicate
negations. The absolute values of an entry correspond to the predictor
index in \code{X}.}

\item{Z.interactions}{Shall interactions with the continuous covariable
\code{Z} be taken into account by including products of the terms with
\code{Z}?}
}
\value{
A \code{linear.logic} model. This is a list containing
  the logic terms used as predictors in the model and the fitted \code{glm}
  model.
}
\description{
This function fits a linear or logistic regression model (based on the
type of outcome) using the supplied logic terms, e.g., \code{$disj} from
a fitted \code{logicDT} model.
}
