% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{bootstrapping}
\alias{bootstrapping}
\alias{basicConfig}
\alias{logReset}
\title{Bootstrapping the logging package.}
\usage{
basicConfig(level = 20)

logReset()
}
\arguments{
\item{level}{The logging level of the root logger. Defaults to INFO. Please do notice that
this has no effect on the handling level of the handler that basicConfig attaches to the
root logger.}
}
\description{
\code{basicConfig} and \code{logReset} provide a way to put the logging package
in a know initial state.
}
\details{
\code{basicConfig} creates the root logger, attaches a console handler(by
\var{basic.stdout} name) to it and sets the level of the handler to
\code{level}. You must not call \code{basicConfig} to for logger to work any more:
then root logger is created it gets initialized by default the same way as
\code{basicConfig} does. If you need clear logger to fill with you own handlers
use \code{logReset} to remove all default handlers.

\code{logReset} reinitializes the whole logging system as if the package had just been
loaded except it also removes all default handlers. Typically, you would want to call
\code{basicConfig} immediately after a call to \code{logReset}.
}
\examples{
basicConfig()
logdebug("not shown, basic is INFO")
logwarn("shown and timestamped")
logReset()
logwarn("not shown, as no handlers are present after a reset")

}
