% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checksim.r
\name{checksim}
\alias{checksim}
\title{Test the computer player performance}
\usage{
checksim(m, ComputerDecision = ComputerDecision.default,
  Simulation = Simulation.default)
}
\arguments{
\item{m}{number of simulations}

\item{ComputerDecision}{function which returns a computer guess on the violation of assumption (see \code{\link{ComputerDecision.default}})}

\item{Simulation}{function which return a sample generated according to different assumptions (see \code{\link{Simulation.default}})}
}
\value{
\item{table}{a 4x4 matrix, this is the frequency of the true data generating mechanism (rows) and the computer guess (column)}
}
\description{
Assesses (by simulation) the performance of an algorithm for detecting non linearity/heteroscedasticity/non normality (\code{\link{ComputerDecision.default}}) on data generated by the function \code{Simulation} (\code{\link{Simulation.default}}).
}
\examples{
checksim(10)

}
\seealso{
\code{\link{ComputerDecision.default}},\code{\link{Simulation.default}}
}
\author{
Francesco Pauli, \email{francesco.pauli@deams.units.it}
}
\keyword{-}
