% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastmru.R
\name{fastmru}
\alias{fastmru}
\title{Fast version of mru. It runs mru without input checks.}
\usage{
fastmru(
  G = NULL,
  X = NULL,
  B = NULL,
  Z = NULL,
  MAXINNER = 32,
  FCRIT = 0.001,
  MAXITER = 65536,
  DCRIT = 1e-06,
  error.check = FALSE
)
}
\arguments{
\item{G}{indicator matrix of the response variable}

\item{X}{matrix with predictor variables}

\item{B}{starting values of the regression weights}

\item{Z}{starting values for class locations}

\item{MAXINNER}{maximum number of iterations in the inner loop}

\item{FCRIT}{convergence criterion for STRESS in the inner loop}

\item{MAXITER}{maximum number of iterations in the outer loop}

\item{DCRIT}{convergence criterion for the deviance}

\item{error.check}{extensive check validity input parameters (default = FALSE).}
}
\value{
B estimated regression weights

V estimated class locations

Lastinner number of iterations in the last call to STRESS

Lastfdif last difference in STRESS values in the inner loop

lastouter number of iterations in the outer loop

lastddif last difference in deviances in outer loop

deviance obtained deviance
}
\description{
Fast version of mru. It runs mru without input checks.
}
