% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmdu.R
\name{lmdu}
\alias{lmdu}
\title{The function lmdu performs logistic mdu with or without predictors to obtain
a unsupervised or supervised mapping of binary response variables.}
\usage{
lmdu(
  Y,
  f = NULL,
  X = NULL,
  S = 2,
  start = "svd",
  maxiter = 65536,
  dcrit = 1e-05
)
}
\arguments{
\item{Y}{An N times R binary matrix  .}

\item{f}{Vector with frequencies of response patterns in Y (only applicable if (X = NULL))}

\item{X}{An N by P matrix with predictor variables}

\item{S}{Positive number indicating the dimensionality of the solution}

\item{start}{Either user provided starting values (start should be a list with U and V) or a way to compute starting values (choices: random, svd, ca)}

\item{maxiter}{maximum number of iterations}

\item{dcrit}{convergence criterion}
}
\value{
deviance
}
\description{
This function runs:
logistic multidimensional unfolding (if X = NULL)
logistic restricted multidimensional unfolding (if X != NULL)
}
\examples{
data(dataExample_lmdu)
Y = as.matrix(dataExample_lmdu[1:20 , 1:8])
X = as.matrix(dataExample_lmdu[1:20 , 9:13])
# unsupervised
output = lmdu(Y = Y, S = 2)

}
