% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linpk.R
\name{pkprofile.pkprofile}
\alias{pkprofile.pkprofile}
\title{Continue an existing concentration-time profile.}
\usage{
\method{pkprofile}{pkprofile}(obj, t.obs = finaltime(obj) + seq(0, 24, 0.1), ..., append = TRUE)
}
\arguments{
\item{obj}{An object returned from a previous call to \code{\link{pkprofile}}.}

\item{t.obs}{A numeric vector of times at which to observe concentrations.}

\item{...}{Further arguments passed along.}

\item{append}{Should the new profile be appended to the current samples?
Otherwise, only the new samples are returned.}
}
\value{
An object of class "pkprofile".
}
\description{
This method can be used to append to an existing PK profile, for instance to
simulate a PK profile with parameters that change over time. Each time the
parameters change, a new call to this method is used to advance the system
with the new parameter values.
}
\section{Warning}{

The new parameters take effect at the time when the previous profile ends.
If the previous profile ends before the new sampling starts, the \emph{new}
parameters will be used to advance the system to the start of the new
sampling.

Any ongoing zero-order infusion at the end of the previous profile is
dropped. The remaining infusion amount will NOT be carried forward.
}

\examples{
t.obs <- seq(0, 24, 0.1)
amt <- 1
ka <- 1
cl <- 0.25
vc <- 5

# One-compartment model with first-order absorption
# First dose at time 0
y <- pkprofile(t.obs, cl=cl, vc=vc, ka=ka, dose=list(t.dose=0, amt=amt))

# Second dose at 24h with a lower clearance
y <- pkprofile(y, t.obs+24, cl=0.5*cl, vc=vc, ka=ka, dose=list(t.dose=24, amt=amt))

# Third dose at 48h with a higher clearance
y <- pkprofile(y, t.obs+48, cl=2*cl, vc=vc, ka=ka, dose=list(t.dose=48, amt=amt))
plot(y)

}
\seealso{
\code{\link{pkprofile}}
}
