\name{cutDendrogramAt}
\alias{cutDendrogramAt}

\title{
Extract Meta-Communities
}
\description{
This function extracts meta-communities from a dendrogram of community relatedness based on a user-defined place at which to cut the dendrogram.
}
\usage{
cutDendrogramAt(x, lc = NULL, cutat = NULL, plot = TRUE, col = TRUE, 
                pal = brewer.pal(9, "Set1"), labels = FALSE, plotcut = TRUE, 
                right = TRUE, ...)
}

\arguments{
  \item{x}{
An object of class \code{hclust}, usually generated by \code{getClusterRelatedness}.
}
  \item{lc}{
An object of class \code{linkcomm}. If included, the resulting plot will display additional information about the clusters. Defaults to NULL.
}
  \item{cutat}{
A numerical value at which to cut the dendrogram.
}
  \item{plot}{
Logical, whether to plot the dendrogram and the meta-communities, defaults to TRUE.
}
  \item{col}{
Logical, whether to colour the meta-communites.
}
  \item{pal}{
A character vector describing a colour palette to be used for colouring the meta-communites in the dendrogram plot. Defaults to \code{brewer.pal(9, "Set1")}.
}
  \item{labels}{
Logical, whether to put labels on the dendrogram. Defaults to FALSE.
}
  \item{plotcut}{
Logical, whether to display a horizontal line where the dendrogram is cut. Defaults to TRUE.
}
  \item{right}{
Logical, whether to orient the dendrogram to the right. Defaults to TRUE.
}
  \item{\dots}{
Additional arguments to be passed to \code{plot}.
}
}
\details{
Extracting meta-communities allows the user to explore community relatedness and structure at higher levels.
}
\value{
A list of integer vectors, referring to meta-communities of link communities.
}
\references{
Kalinka, A.T. and Tomancak, P. (2011). linkcomm: an R package for the generation, visualization, and analysis of link communities in networks of arbitrary size and type. Bioinformatics, doi: 10.1093/bioinformatics/btr311.
}
\author{
Alex T. Kalinka \email{alex.t.kalinka@gmail.com}
}

\seealso{
\code{\link{getClusterRelatedness}}
}
\examples{
## Generate graph, extract link communities, and cluster communities.
g <- swiss[,3:4]
lc <- getLinkCommunities(g)
hc <- getClusterRelatedness(lc)

## Cut dendrogram at 1 and extract meta-communities.
cutDendrogramAt(hc, cutat = 1)
}

