% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limer_get_responses.R
\name{limer_get_responses}
\alias{limer_get_responses}
\title{Export data from a LimeSurvey survey}
\usage{
limer_get_responses(
  iSurveyID,
  sDocumentType = "csv",
  sLanguageCode = NULL,
  sCompletionStatus = "complete",
  sHeadingType = "code",
  sResponseType = "long",
  encoding_limerCall = NULL,
  encoding_txtCon = NULL,
  ...
)
}
\arguments{
\item{iSurveyID}{The LimeSurvey survey identifier (the \code{sid}, usually
6 digits long).}

\item{sDocumentType}{\dots}

\item{sLanguageCode}{\dots}

\item{sCompletionStatus}{\dots}

\item{sHeadingType}{\dots}

\item{sResponseType}{\dots}

\item{encoding_limerCall}{The encoding to pass to
the \code{\link[=limer_call_limer]{limer_call_limer()}} function.}

\item{encoding_txtCon}{The encoding to pass to
\code{\link[=limer_base64_to_df]{limer_base64_to_df()}}.}

\item{\dots}{Further arguments to \code{\link{limer_call_limer}}.}
}
\description{
This function exports and downloads data from a LimeSurvey survey.
}
\examples{
\dontrun{
limer_get_responses(12345)
}
}
