% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-LAS.R, R/methods-LAS.R
\docType{class}
\name{LAS-class}
\alias{LAS-class}
\alias{LAS}
\title{An S4 class to represent a .las or .laz file}
\usage{
LAS(data, header = list(), crs = sf::NA_crs_, check = TRUE, index = NULL, ...)
}
\arguments{
\item{data}{a \link[data.table:data.table]{data.table} containing the data of a las or laz file.}

\item{header}{a \code{list} or a \link[=LASheader-class]{LASheader} containing the header of
a las or laz file.}

\item{crs}{crs object of class \link[sf:st_crs]{crs} from sf}

\item{check}{logical. Conformity tests while building the object.}

\item{index}{list with two elements \code{list(sensor = 0L, index = 0L)}.
See \link[=lidR-spatial-index]{spatial indexing}}

\item{...}{internal use}
}
\value{
An object of class \code{LAS}
}
\description{
Class LAS is the representation of a las/laz file according to the
\href{https://www.asprs.org/wp-content/uploads/2019/07/LAS_1_4_r15.pdf}{LAS file format specifications}.
}
\details{
A \code{LAS} object contains a \code{data.table} with the data read from a \code{las/laz} file and
a \link[=LASheader-class]{LASheader} (see the ASPRS documentation for the
\href{https://www.asprs.org/a/society/committees/standards/LAS_1_4_r13.pdf}{LAS file format}
for more information). Because las files are standardized the table of attributes read from the las/laz file
is also standardized. Columns are named:
\itemize{
\item{\code{X}, \code{Y}, \code{Z} (numeric)}
\item{\code{gpstime} (numeric)}
\item{\code{Intensity} (integer)}
\item{\code{ReturnNumber}, \code{NumberOfReturns} (integer)}
\item{\code{ScanDirectionFlag} (integer)}
\item{\code{EdgeOfFlightline} (integer)}
\item{\code{Classification} (integer)}
\item{\code{Synthetic_flag},\code{Keypoint_flag}, \code{Withheld_flag}  (logical)}
\item{\code{ScanAngleRank}/\code{ScanAngle}  (integer/numeric)}
\item{\code{UserData} (integer)}
\item{\code{PointSourceID} (integer)}
\item{\code{R},\code{G},\code{B}, \code{NIR} (integer)}
}
}
\section{Functions}{
\itemize{
\item \code{LAS()}: creates objects of class LAS. The original data is updated by reference to
quantize the coordinates according to the scale factor of the header if no header is provided.
In this case the scale factor is set to 0.001

}}
\section{Slots}{

\describe{
\item{\code{crs}}{Object of class \link[sf:st_crs]{crs} from sf.}

\item{\code{data}}{Object of class \link[data.table:data.table]{data.table}. Point cloud data according to the
\href{https://www.asprs.org/wp-content/uploads/2019/07/LAS_1_4_r15.pdf}{LAS file format}}

\item{\code{header}}{Object of class \link[=LASheader-class]{LASheader}. LAS file header according to the
\href{https://www.asprs.org/wp-content/uploads/2019/07/LAS_1_4_r15.pdf}{LAS file format}}

\item{\code{index}}{list. See \link[=lidR-spatial-index]{spatial indexing}.}
}}

\examples{
# Read a las/laz file
LASfile <- system.file("extdata", "example.laz", package="rlas")
las <- readLAS(LASfile)
las

# Creation of a LAS object out of external data
data <- data.frame(X = runif(100, 0, 100),
                   Y = runif(100, 0, 100),
                   Z = runif(100, 0, 20))

# 'data' has many decimal digits
data

# Create a default header and quantize *by reference*
# the coordinates to fit with offset and scale factors
cloud <- LAS(data)

# 'data' has been updated and coordinates were quantized
data
cloud

# Be careful when providing a header the function assumes that
# it corresponds to the data and won't quantize the coordinates
data <- data.frame(X = runif(100, 0, 100),
                   Y = runif(100, 0, 100),
                   Z = runif(100, 0, 20))
header <- header(las)

# This works but triggers warnings and creates an invalid LAS object
cloud <- LAS(data, header)

las_check(cloud)
}
\seealso{
\link{readLAS}
}
