% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-lascatalog.r
\name{catalog}
\alias{catalog}
\alias{cores}
\alias{cores<-}
\alias{by_file}
\alias{by_file<-}
\alias{buffer}
\alias{buffer<-}
\alias{progress}
\alias{progress<-}
\alias{tiling_size}
\alias{tiling_size<-}
\alias{vrt}
\alias{vrt<-}
\alias{stop_early}
\alias{stop_early<-}
\title{Build a catalog of las tiles/files}
\usage{
catalog(folder, ...)

cores(ctg)

cores(ctg) <- value

by_file(ctg)

by_file(ctg) <- value

buffer(ctg)

buffer(ctg) <- value

progress(ctg)

progress(ctg) <- value

tiling_size(ctg)

tiling_size(ctg) <- value

vrt(ctg)

vrt(ctg) <- value

stop_early(ctg)

stop_early(ctg) <- value
}
\arguments{
\item{folder}{string. The path of a folder containing a set of .las files}

\item{\dots}{Extra parameters to \link[base:list.files]{list.files}. Typically `recursive = TRUE`.}

\item{ctg}{A LAScatalog object.}

\item{value}{An appropriated value for catalog settings. See \link[lidR:LAScatalog-class]{LAScatalog}}
}
\value{
A \code{LAScatalog} object
}
\description{
Build a \link[lidR:LAScatalog-class]{LAScatalog} object from a folder name. A catalog is the
representation of a set of las files, since a computer cannot load all the data at once. A
catalog is a simple way to manage all the files sequentially by reading only the headers. Also a
catalog contains metadata so users can configure how it will be processed.
}
\seealso{
\link{LAScatalog-class}
\link[lidR:plot.LAScatalog]{plot}
\link{catalog_apply}
\link{catalog_queries}
}
