% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{stable_pdf_and_cdf}
\alias{stable_pdf_and_cdf}
\alias{stable_pdf}
\alias{stable_cdf}
\title{PDF and CDF of a skew stable distribution.}
\usage{
stable_pdf(x, pars, parametrization = 0L, tol = 1e-12)
}
\arguments{
\item{x}{Vector of points where the pdf will be evaluated.}

\item{pars}{Vector with an initial estimation of the parameters. \code{pars_init = c(alpha, beta, sigma, mu)}, where
\itemize{
\item alpha: shape / stability parameter, with 0 < alpha <= 2.
\item beta: skewness parameter, with -1 <= beta <= 1.
\item sigma: scale parameter, with 0 < sigma.
\item mu: location parameter, with mu real.
}}

\item{parametrization}{Parametrization used for the skew stable distribution, as defined by JP Nolan (1997). By default, parametrization = 0.}

\item{tol}{Relative error tolerance (precission) of the calculated values. By default, tol = 1e-12.}
}
\value{
A numeric vector.
}
\description{
Evaluate the PDF or the CDF of the skew stable distribution with parameters
pars = c(alpha, beta, sigma, mu) at the points given in x.\cr\cr
\emph{parametrization} argument specifies the parametrization used for the distribution
as described by JP Nolan (1997). The default value is \emph{parametrization} = 0.\cr\cr
\emph{tol} sets the relative error tolerance (precision) to \emph{tol}. The default value is tol = 1e-12.
}
\examples{
pars <- c(1.5, 0.9, 1, 0)
x <- seq(-5, 10, 0.001)

pdf <- stable_pdf(x, pars)
cdf <- stable_cdf(x, pars)

plot(x, pdf, type = "l")
}
\references{
Nolan JP (1997). Numerical Calculation of Stable Densities and Distribution Functions. Stochastic Models, 13(4) 759-774.
}
\author{
Javier Royuela del Val, Federico Simmross Wattenberg and Carlos Alberola López\cr\cr
Maintainer: Javier Royuela del Val \href{mailto:jroyval@lpi.tel.uva.es}{jroyval@lpi.tel.uva.es}
}
\keyword{distribution}
