/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/OtherMethod.h>
#include <so/private/OtherMethod.h>

so_OtherMethod *so_OtherMethod_new()
{
	so_OtherMethod *object = calloc(sizeof(so_OtherMethod), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_OtherMethod *so_OtherMethod_copy(so_OtherMethod *self)
{
	so_OtherMethod *dest = so_OtherMethod_new();
	if (dest) {
		if (self->method) {
			dest->method = pharmml_strdup(self->method);
			if (!dest->method) {
				so_OtherMethod_free(dest);
				return NULL;
			}
		}
		if (self->Mean) {
			dest->Mean = so_Table_copy(self->Mean);
			if (!dest->Mean) {
				so_OtherMethod_free(dest);
				return NULL;
			}
		}
		if (self->Median) {
			dest->Median = so_Table_copy(self->Median);
			if (!dest->Median) {
				so_OtherMethod_free(dest);
				return NULL;
			}
		}
	}

	return dest;
}

void so_OtherMethod_free(so_OtherMethod *self)
{
	if (self) {
		so_Table_unref(self->Mean);
		so_Table_unref(self->Median);
		if (self->method) free(self->method);
		free(self);
	}
}

void so_OtherMethod_ref(so_OtherMethod *self)
{
	self->reference_count++;
}

void so_OtherMethod_unref(so_OtherMethod *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_OtherMethod_free(self);
		}
	}
}

char *so_OtherMethod_get_method(so_OtherMethod *self)
{
	return self->method;
}

so_Table *so_OtherMethod_get_Mean(so_OtherMethod *self)
{
	return self->Mean;
}

so_Table *so_OtherMethod_get_Median(so_OtherMethod *self)
{
	return self->Median;
}

int so_OtherMethod_set_method(so_OtherMethod *self, char *value)
{
	if (!value) {
		self->method = value;
		return 0;
	}
	char *new_value = pharmml_strdup(value);
	if (new_value) {
		free(self->method);
		self->method = new_value;
		return 0;
	} else {
		return 1;
	}
}

void so_OtherMethod_set_Mean(so_OtherMethod *self, so_Table *value)
{
	so_Table_unref(self->Mean);
	self->Mean = value;
}

void so_OtherMethod_set_Median(so_OtherMethod *self, so_Table *value)
{
	so_Table_unref(self->Median);
	self->Median = value;
}

so_Table *so_OtherMethod_create_Mean(so_OtherMethod *self)
{
	so_Table *obj = so_Table_new("Mean");
	if (obj) {
		self->Mean = obj;
	}
	return obj;
}

so_Table *so_OtherMethod_create_Median(so_OtherMethod *self)
{
	so_Table *obj = so_Table_new("Median");
	if (obj) {
		self->Median = obj;
	}
	return obj;
}

int so_OtherMethod_xml(so_OtherMethod *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->Mean || self->Median || self->method) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "OtherMethod");
		if (rc < 0) return 1;
		if (self->method) {
			rc = xmlTextWriterWriteAttribute(writer, BAD_CAST "method", BAD_CAST self->method);
			if (rc < 0) return 1;
		}
		if (self->Mean) {
			rc = so_Table_xml(self->Mean, writer, "Mean");
			if (rc != 0) return rc;
		}
		if (self->Median) {
			rc = so_Table_xml(self->Median, writer, "Median");
			if (rc != 0) return rc;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_OtherMethod_start_element(so_OtherMethod *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_Mean) {
		int fail = so_Table_start_element(self->Mean, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_Median) {
		int fail = so_Table_start_element(self->Median, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "Mean") == 0) {
		so_Table *Mean = so_OtherMethod_create_Mean(self);
		if (!Mean) {
			return 1;
		}
		self->in_Mean = 1;
	} else if (strcmp(localname, "Median") == 0) {
		so_Table *Median = so_OtherMethod_create_Median(self);
		if (!Median) {
			return 1;
		}
		self->in_Median = 1;
	}
	return 0;
}

void so_OtherMethod_end_element(so_OtherMethod *self, const char *localname)
{
	if (strcmp(localname, "Mean") == 0 && self->in_Mean) {
		self->in_Mean = 0;
	} else if (strcmp(localname, "Median") == 0 && self->in_Median) {
		self->in_Median = 0;
	} else if (self->in_Mean) {
		so_Table_end_element(self->Mean, localname);
	} else if (self->in_Median) {
		so_Table_end_element(self->Median, localname);
	}
}

int so_OtherMethod_characters(so_OtherMethod *self, const char *ch, int len)
{
	if (self->in_Mean) {
		int fail = so_Table_characters(self->Mean, ch, len);
		if (fail) return 1;
	} else if (self->in_Median) {
		int fail = so_Table_characters(self->Median, ch, len);
		if (fail) return 1;
	}
	return 0;
}

int so_OtherMethod_init_attributes(so_OtherMethod *self, int nb_attributes, const char **attributes)
{
	unsigned int index = 0;
	for (int i = 0; i < nb_attributes; i++, index += 5) {
		const char *localname = attributes[index];
		const char *valueBegin = attributes[index + 3];
		const char *valueEnd = attributes[index + 4];

		if (strcmp(localname, "method") == 0) {
			self->method = pharmml_strndup(valueBegin, valueEnd - valueBegin);
			if (!self->method) {
				return 1;
			}
		}
	}
	return 0;
}
