/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_INFORMATIONCRITERIA_H
#define _SO_INFORMATIONCRITERIA_H


/** \struct so_InformationCriteria
	 \brief A structure representing an SO/SOBlock/Estimation/OFMeasures/InformationCriteria element
*/
typedef struct so_InformationCriteria so_InformationCriteria;

/** \memberof so_InformationCriteria
 * Create a new empty so_InformationCriteria structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_InformationCriteria_copy, so_InformationCriteria_free
 */
so_InformationCriteria *so_InformationCriteria_new();
/** \memberof so_InformationCriteria
 * Create a copy of a so_InformationCriteria structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_InformationCriteria_new
 */
so_InformationCriteria *so_InformationCriteria_copy(so_InformationCriteria *self);
/** \memberof so_InformationCriteria
 * Free all memory associated with a so_InformationCriteria structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_InformationCriteria_new
 */
void so_InformationCriteria_free(so_InformationCriteria *self);
void so_InformationCriteria_ref(so_InformationCriteria *self);
void so_InformationCriteria_unref(so_InformationCriteria *self);
/** \memberof so_InformationCriteria
 * Get the AIC element
 * \param self - pointer to a so_InformationCriteria
 * \return A pointer to the value of AIC or NULL if no value is present.
 * \sa so_InformationCriteria_set_AIC
 */
double *so_InformationCriteria_get_AIC(so_InformationCriteria *self);
/** \memberof so_InformationCriteria
 * Get the BIC element
 * \param self - pointer to a so_InformationCriteria
 * \return A pointer to the value of BIC or NULL if no value is present.
 * \sa so_InformationCriteria_set_BIC
 */
double *so_InformationCriteria_get_BIC(so_InformationCriteria *self);
/** \memberof so_InformationCriteria
 * Get the DIC element
 * \param self - pointer to a so_InformationCriteria
 * \return A pointer to the value of DIC or NULL if no value is present.
 * \sa so_InformationCriteria_set_DIC
 */
double *so_InformationCriteria_get_DIC(so_InformationCriteria *self);
/** \memberof so_InformationCriteria
 * Set the AIC element
 * \param self - pointer to a so_InformationCriteria
 * \param value - A pointer to the value to set or NULL to not include this element.
 * \sa so_InformationCriteria_get_AIC
 */
void so_InformationCriteria_set_AIC(so_InformationCriteria *self, double *value);
/** \memberof so_InformationCriteria
 * Set the BIC element
 * \param self - pointer to a so_InformationCriteria
 * \param value - A pointer to the value to set or NULL to not include this element.
 * \sa so_InformationCriteria_get_BIC
 */
void so_InformationCriteria_set_BIC(so_InformationCriteria *self, double *value);
/** \memberof so_InformationCriteria
 * Set the DIC element
 * \param self - pointer to a so_InformationCriteria
 * \param value - A pointer to the value to set or NULL to not include this element.
 * \sa so_InformationCriteria_get_DIC
 */
void so_InformationCriteria_set_DIC(so_InformationCriteria *self, double *value);

#endif
