/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#include <R.h>
#include <Rdefines.h>
#include <so.h>
#include "soc.h"

SEXP r_so_Bayesian_new()
{
	so_Bayesian *obj = so_Bayesian_new();
	if (!obj) {
		error("Failed to create so_Bayesian object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_Bayesian_copy(SEXP self)
{
	so_Bayesian *obj = so_Bayesian_copy(R_ExternalPtrAddr(self));
	if (!obj) {
		error("Failed to copy so_Bayesian object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_Bayesian_free(SEXP self)
{
	so_Bayesian_free(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_Bayesian_ref(SEXP self)
{
	so_Bayesian_ref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_Bayesian_unref(SEXP self)
{
	so_Bayesian_unref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_Bayesian_get_PosteriorMean(SEXP self)
{
	so_Table *child = so_Bayesian_get_PosteriorMean(R_ExternalPtrAddr(self));
	SEXP result = table2df(child);
	return result;
}

SEXP r_so_Bayesian_set_PosteriorMean(SEXP self, SEXP child)
{
	so_Table *table = df2table(child);
	so_Bayesian_set_PosteriorMean(R_ExternalPtrAddr(self), table);
	return R_NilValue;
}

SEXP r_so_Bayesian_create_PosteriorMean(SEXP self)
{
	so_Table *child = so_Bayesian_create_PosteriorMean(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_Bayesian_get_PosteriorMedian(SEXP self)
{
	so_Table *child = so_Bayesian_get_PosteriorMedian(R_ExternalPtrAddr(self));
	SEXP result = table2df(child);
	return result;
}

SEXP r_so_Bayesian_set_PosteriorMedian(SEXP self, SEXP child)
{
	so_Table *table = df2table(child);
	so_Bayesian_set_PosteriorMedian(R_ExternalPtrAddr(self), table);
	return R_NilValue;
}

SEXP r_so_Bayesian_create_PosteriorMedian(SEXP self)
{
	so_Table *child = so_Bayesian_create_PosteriorMedian(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_Bayesian_get_PosteriorMode(SEXP self)
{
	so_Table *child = so_Bayesian_get_PosteriorMode(R_ExternalPtrAddr(self));
	SEXP result = table2df(child);
	return result;
}

SEXP r_so_Bayesian_set_PosteriorMode(SEXP self, SEXP child)
{
	so_Table *table = df2table(child);
	so_Bayesian_set_PosteriorMode(R_ExternalPtrAddr(self), table);
	return R_NilValue;
}

SEXP r_so_Bayesian_create_PosteriorMode(SEXP self)
{
	so_Table *child = so_Bayesian_create_PosteriorMode(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

