/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_RESIDUALS_H
#define _SO_RESIDUALS_H

#include <so/Table.h>

/** \struct so_Residuals
	 \brief A structure representing an SO/SOBlock/Estimation/Residuals element
*/
typedef struct so_Residuals so_Residuals;

/** \memberof so_Residuals
 * Create a new empty so_Residuals structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_Residuals_copy, so_Residuals_free
 */
so_Residuals *so_Residuals_new();
/** \memberof so_Residuals
 * Create a copy of a so_Residuals structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_Residuals_new
 */
so_Residuals *so_Residuals_copy(so_Residuals *self);
/** \memberof so_Residuals
 * Free all memory associated with a so_Residuals structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_Residuals_new
 */
void so_Residuals_free(so_Residuals *self);
void so_Residuals_ref(so_Residuals *self);
void so_Residuals_unref(so_Residuals *self);
/** \memberof so_Residuals
 * Get the ResidualTable element
 * \param self - pointer to a so_Residuals
 * \return A pointer to the structure representing the ResidualTable element
 * \sa so_Residuals_set_ResidualTable
 */
so_Table *so_Residuals_get_ResidualTable(so_Residuals *self);
/** \memberof so_Residuals
 * Get the EpsShrinkage element
 * \param self - pointer to a so_Residuals
 * \return A pointer to the structure representing the EpsShrinkage element
 * \sa so_Residuals_set_EpsShrinkage
 */
so_Table *so_Residuals_get_EpsShrinkage(so_Residuals *self);
/** \memberof so_Residuals
 * Set the ResidualTable element
 * \param self - pointer to a so_Residuals
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_Residuals_get_ResidualTable
 */
void so_Residuals_set_ResidualTable(so_Residuals *self, so_Table *value);
/** \memberof so_Residuals
 * Set the EpsShrinkage element
 * \param self - pointer to a so_Residuals
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_Residuals_get_EpsShrinkage
 */
void so_Residuals_set_EpsShrinkage(so_Residuals *self, so_Table *value);
/** \memberof so_Residuals
 * Create a new ResidualTable element and insert it into the so_Residuals
 * \param self - pointer to a so_Residuals
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_Residuals_create_ResidualTable(so_Residuals *self);
/** \memberof so_Residuals
 * Create a new EpsShrinkage element and insert it into the so_Residuals
 * \param self - pointer to a so_Residuals
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_Residuals_create_EpsShrinkage(so_Residuals *self);

#endif
