% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{get_2ndDerivPenalty}
\alias{get_2ndDerivPenalty}
\title{Compute Integrated Squared Second Derivative Penalty Matrix for Smoothing Splines}
\usage{
get_2ndDerivPenalty(
  colnm_expansions,
  C,
  power1_cols,
  power2_cols,
  power3_cols,
  power4_cols,
  interaction_single_cols,
  interaction_quad_cols,
  triplet_cols,
  nc,
  select_cols = NULL
)
}
\arguments{
\item{colnm_expansions}{Character vector of column names for basis expansions}

\item{C}{Numeric matrix of basis expansions}

\item{power1_cols}{Indices of linear term columns}

\item{power2_cols}{Indices of quadratic term columns}

\item{power3_cols}{Indices of cubic term columns}

\item{power4_cols}{Indices of quartic term columns}

\item{interaction_single_cols}{Indices of single interaction columns}

\item{interaction_quad_cols}{Indices of quadratic interaction columns}

\item{triplet_cols}{Indices of triplet interaction columns}

\item{nc}{Number of cubic expansions}

\item{select_cols}{Optional vector of column indices to penalize (default: all linear terms)}
}
\value{
A symmetric \eqn{p \times p} penalty matrix \eqn{\textbf{P}} representing integrated squared second derivatives
for basis expansions in a single partition of the smoothing spline.
}
\description{
Generates a penalty matrix representing the integrated squared second derivatives
for smoothing spline basis functions, which controls the smoothness of the fitted curve.
}
\details{
This function computes the analytic form of the traditional integrated, squared, second-derivative evaluated over the bounds of the input data.
If \eqn{f(x) = \textbf{X}\boldsymbol{\beta}}, then the penalty is based on \eqn{\int \{ f''(x) \}^2 dx = \boldsymbol{\beta}^{T}(\int \textbf{X}''^{T}\textbf{X}'' dx)\boldsymbol{\beta}}.
This function computes the matrix \eqn{\textbf{P} = \int \textbf{X}''^{T}\textbf{X}'' dx}.
When scaled by a non-negative scalar (wiggle penalty, predictor penalties and/or partition penalties), this becomes the smoothing spline penalty.
}
\keyword{internal}
