% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Appender.R
\name{AppenderConsole}
\alias{AppenderConsole}
\title{Log to the Console}
\description{
A simple Appender that outputs to the console. If you have the package
\strong{crayon} installed log levels will be coloured by default
(but you can modify this behaviour by passing a custom \link{Layout}).
}
\section{Usage}{
\preformatted{
x <- AppenderConsole$new(threshold = NA_integer_, layout = LayoutFormat$new(fmt
  = "\%L [\%t] \%m \%f", timestamp_fmt = "\%H:\%M:\%OS3", colors =
  getOption("lgr.colors", list())), filters = NULL)

x$add_filter(filter, name = NULL)
x$append(event)
x$filter(event)
x$remove_filter(pos)
x$set_filters(filters)
x$set_layout(layout)
x$set_threshold(level)

x$destination
x$filters
x$layout
x$threshold

}
}

\section{Creating a New Appender}{


New Appenders are instantiated with \code{<AppenderSubclass>$new()}. For the
arguments to \code{new()} please refer to the section \emph{Fields}. You can also
modify those fields after the Appender has been created with setters in the
form of \code{appender$set_<fieldname>(value)}
}

\section{Fields}{


\describe{
\item{\code{threshold}, \code{set_threshold(level)}}{\code{character} or \code{integer} scalar.
The minimum log level that triggers this logger. See \link{log_levels}}
\item{\code{layout}, \code{set_layout(layout)}}{a \code{Layout} that will be used for
formatting the \code{LogEvents} passed to this Appender}
\item{\code{destination}}{The output destination of the \code{Appender} in
human-readable form (mainly for print output)}
}



\describe{
\item{\code{filters}, \code{set_filters(filters)}}{a \code{list} that may contain
\code{functions} or any \R object with a \code{filter()} method. These functions
must have exactly one argument: \code{event} which will get passed the
LogEvent when the Filterable's \code{filter()} method is invoked.
If all of these functions evaluate to \code{TRUE} the LogEvent is passed on.
Since LogEvents have reference semantics, filters can also be abused to
modify them before they are passed on. Look at the source code of
\code{\link[=with_log_level]{with_log_level()}} or \code{\link[=with_log_value]{with_log_value()}} for examples.
}
}
}

\section{Methods}{

\describe{
\item{\code{append(event)}}{Tell the Appender to process a \link{LogEvent} \code{event}.
This method is usually not called by the user, but invoked by a
\link{Logger}
}
}


\describe{
\item{\code{filter(event)}}{Determine whether the LogEvent \code{x} should be passed
on to Appenders (\code{TRUE}) or not (\code{FALSE}). See also the active binding
\code{filters}}
\item{\code{add_filter(filter, name = NULL)}, \code{remove_filter(pos)}}{
Add or remove a filter. When adding a filter an optional \code{name} can
be specified. \code{remove_filter()} can remove by position or name (if one
was specified)
}
}
}

\examples{
# create a new logger with propagate = FALSE to prevent routing to the root
# logger. Please look at the section "Logger Hirarchies" in the package
# vignette for more info.
lg  <- get_logger("test")$set_propagate(FALSE)

lg$add_appender(AppenderConsole$new())
lg$add_appender(AppenderConsole$new(
  layout = LayoutFormat$new("[\%t] \%c(): [\%n] \%m", colors = getOption("lgr.colors"))))

# Will output the message twice because we attached two console appenders
lg$warn("A test message")
lg$config(NULL) # reset config
}
\seealso{
\link{LayoutFormat}

Other Appenders: \code{\link{AppenderBuffer}},
  \code{\link{AppenderDbi}},
  \code{\link{AppenderFileRotating}},
  \code{\link{AppenderFile}}, \code{\link{AppenderGmail}},
  \code{\link{AppenderJson}},
  \code{\link{AppenderPushbullet}},
  \code{\link{AppenderRjdbc}},
  \code{\link{AppenderSendmail}},
  \code{\link{AppenderTable}}, \code{\link{Appender}}
}
\concept{Appenders}
