% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_estimation.R
\name{dlg_marginal}
\alias{dlg_marginal}
\title{Marginal density estimation}
\usage{
dlg_marginal(x, bw = 1, eval_points = seq(quantile(x, 0.01),
  quantile(x, 0.99), length.out = grid_size), grid_size = 15)
}
\arguments{
\item{x}{The data vector.}

\item{bw}{The bandwidth (a single number).}

\item{eval_points}{The grid where we want to evaluate the density. Chosen
suitably if not provided, with length equal to grid_size.}

\item{grid_size}{Number of grid points if grid is not provided.}
}
\value{
A list including the data set \code{$x}, the grid
  \code{$eval_points}, the bandwidth \code{$bw}, as well as a matrix of the
  estimated parameter estimates \code{$par_est} and the estimated bivariate
  density \code{$f_est}.
}
\description{
Function that estimates a univariate density estimation by local Gaussian
approximations, as described in Hufthammer and Tjøstheim (2009).
}
\details{
This function is mainly mean to be used as a tool in multivariate analysis as
away to obtain the estimate of a univariate (marginal) density function, but
it can of course be used in general to estimate univariate densities.
}
\examples{
  x <- rnorm(100)
  estimate <- dlg_marginal(x, bw = 1, eval_points = -4:4)

}
\references{
Hufthammer, Karl Ove, and Dag Tjøstheim. "Local Gaussian Likelihood and Local
Gaussian Correlation" PhD Thesis of Karl Ove Hufthammer, University of
Bergen, 2009.
}
