% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.specific.R
\name{is.specific}
\alias{is.specific}
\title{Determine whether the first set \code{x} of predicates is more specific (or equal)
than \code{y} with respect to \code{vars} and \code{specs}.}
\usage{
is.specific(x, y, fsets, vars = NULL, specs = NULL)
}
\arguments{
\item{x}{The first character vector of predicates.}

\item{y}{The second character vector of predicates.}

\item{fsets}{A valid instance of the \code{\link[=fsets]{fsets()}} class such that all values in \code{x} and \code{y}
can be found in \code{colnames(fsets)}}

\item{vars}{Deprecated parameter must be \code{NULL}.}

\item{specs}{Deprecated parameter must be \code{NULL}.}
}
\value{
TRUE or FALSE (see description).
}
\description{
The function takes two character vectors of predicates and determines whether
\code{x} is more specific (or equal w.r.t. the specificity) than \code{y}. The
specificity relation is fully determined with the values of the \code{\link[=vars]{vars()}} vector
and the \code{\link[=specs]{specs()}} incidence matrix that is encapsulated in the given \code{fsets} object.
}
\details{
Let \eqn{x_i} and \eqn{y_j} represent some predicates of vectors \code{x} and \code{y},
respectively. Function assumes that each vector \code{x} and \code{y} does not
contain two or more predicates with the same value of \code{\link[=vars]{vars()}}.

This function returns TRUE iff all of the following conditions hold:
\itemize{
\item for any \eqn{y_j} there exists \eqn{x_i} such that \eqn{vars[y_j] = vars[x_i]};
\item for any \eqn{x_i} there either does not exist \eqn{y_j} such that
\eqn{vars[x_i] = vars[y_j]}, or \eqn{x_i = y_j}, or \eqn{specs[x_i, y_j] = 1}.
}
}
\examples{
    # prepare fsets object
    v <- c(rep('a', 3), rep('b', 3), rep('c', 3), rep('d', 3))
    s <- matrix(c(0,1,0, 0,0,0, 0,0,0, 0,0,0,
                  0,0,0, 0,0,0, 0,0,0, 0,0,0,
                  0,0,0, 0,0,0, 0,0,0, 0,0,0,

                  0,0,0, 0,1,0, 0,0,0, 0,0,0,
                  0,0,0, 0,0,0, 0,0,0, 0,0,0,
                  0,0,0, 0,0,0, 0,0,0, 0,0,0,

                  0,0,0, 0,0,0, 0,1,0, 0,0,0,
                  0,0,0, 0,0,0, 0,0,0, 0,0,0,
                  0,0,0, 0,0,0, 0,0,0, 0,0,0,

                  0,0,0, 0,0,0, 0,0,0, 0,1,0,
                  0,0,0, 0,0,0, 0,0,0, 0,0,0,
                  0,0,0, 0,0,0, 0,0,0, 0,0,0),
                byrow=TRUE,
                ncol=12)
    m <- matrix(0, nrow=1, ncol=12)
    colnames(m) <- paste(rep(c('VeSm', 'Sm', 'Bi'), times=4),
                         rep(c('a', 'b', 'c', 'd'), each=3),
                         sep='.')
    f <- fsets(m, v, s)


    # returns TRUE
    is.specific(c('VeSm.a', 'Bi.c'),
                c('VeSm.a', 'Bi.c'),
                f)

    # returns TRUE (x and y swapped return FALSE)
    is.specific(c('VeSm.a', 'Bi.c', 'Sm.d'),
                c('Sm.a', 'Bi.c', 'Sm.d'),
                f)

    # returns TRUE (x and y swapped return FALSE)
    is.specific(c('VeSm.a', 'Bi.c', 'Sm.d'),
                c('VeSm.a', 'Bi.c'),
                f)

    # returns TRUE (x and y swapped return FALSE)
    is.specific(c('VeSm.a', 'Bi.c', 'Sm.d'),
                character(),
                f)

    # returns FALSE
    is.specific(c('Sm.a'), c('Bi.c'), f)

    # returns FALSE
    is.specific(c('VeSm.a', 'Sm.c'),
                c('Sm.a', 'Bi.c'),
                f)
}
\seealso{
\code{\link[=perceive]{perceive()}}, \code{\link[=pbld]{pbld()}}, \code{\link[=fsets]{fsets()}}, \code{\link[=vars]{vars()}}, \code{\link[=specs]{specs()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
